/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPProtocolCodecFactory;

public class LLRPConnector
extends LLRPConnection {
    private Logger log = Logger.getLogger(LLRPConnector.class);
    private String host;
    private int port = 5084;
    private NioSocketConnector connector;
    private InetSocketAddress remoteAddress;
    private long connectionTimeout = 10000L;
    private boolean useTLS = false;

    public LLRPConnector() {
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, int port) {
        this.endpoint = endpoint;
        this.host = host;
        this.port = port;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host) {
        this.endpoint = endpoint;
        this.host = host;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.host = host;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, int port, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.host = host;
        this.port = port;
    }

    public void connect() throws LLRPConnectionAttemptFailedException {
        this.connect(10000L);
    }

    public void connect(long timeout) throws LLRPConnectionAttemptFailedException {
        boolean useTLS = false;
        this.connect(timeout, false);
    }

    public void connect(long timeout, boolean useTLS) throws LLRPConnectionAttemptFailedException {
        if (this.session != null && this.session.isConnected() || this.connector != null && !this.connector.isDisposed()) {
            throw new LLRPConnectionAttemptFailedException("Active connection already exists.");
        }
        this.connectionTimeout = timeout;
        this.useTLS = useTLS;
        this.connector = new NioSocketConnector();
        this.connector.setConnectTimeoutMillis(this.connectionTimeout);
        this.connector.getFilterChain().addLast("codec", new ProtocolCodecFilter(new LLRPProtocolCodecFactory(1)));
        if (useTLS) {
            this.addTlsFilter();
        }
        this.connector.setHandler(this.handler);
        this.remoteAddress = new InetSocketAddress(this.host, this.port);
        try {
            ConnectFuture future = this.connector.connect(this.remoteAddress);
            future.awaitUninterruptibly();
            this.session = future.getSession();
            this.checkLLRPConnectionAttemptStatus(timeout);
        }
        catch (RuntimeException e) {
            this.connector.dispose();
            throw e;
        }
        catch (LLRPConnectionAttemptFailedException e) {
            this.connector.dispose();
            throw e;
        }
    }

    private void addTlsFilter() throws LLRPConnectionAttemptFailedException {
        SSLContext sslContext = null;
        try {
            String EncryptionProtocol = "TLSv1.2";
            sslContext = SSLContext.getInstance("TLSv1.2");
            KeyManager[] KeyManagers = null;
            TrustManager[] TrustAllCertificates = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sslContext.init(KeyManagers, TrustAllCertificates, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            throw new LLRPConnectionAttemptFailedException(e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new LLRPConnectionAttemptFailedException(e.getMessage());
        }
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setUseClientMode(true);
        sslFilter.setNeedClientAuth(false);
        this.connector.getFilterChain().addFirst("sslFilter", sslFilter);
    }

    public void disconnect() {
        try {
            if (this.session != null) {
                boolean closeImmediately = false;
                CloseFuture future = this.session.close(false);
                future.awaitUninterruptibly();
            }
        }
        finally {
            if (this.connector != null && !this.connector.isDisposed()) {
                this.connector.dispose();
            }
        }
    }

    @Override
    @Deprecated
    public boolean reconnect() {
        try {
            this.connect(this.connectionTimeout, this.useTLS);
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (LLRPConnectionAttemptFailedException e) {
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

