/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjDisabledAntennas;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationAlgorithmControl;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjLocationConfig
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1542);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjLocationConfig.class);
    protected UnsignedShort computeWindowSeconds;
    protected UnsignedShort tagAgeIntervalSeconds;
    protected UnsignedShort updateIntervalSeconds;
    private ImpinjDisabledAntennas impinjDisabledAntennas;
    private ImpinjLocationAlgorithmControl impinjLocationAlgorithmControl;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjLocationConfig() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjLocationConfig(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjLocationConfig(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1542);
        this.decodeXML(element);
    }

    public ImpinjLocationConfig(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.computeWindowSeconds == null) {
            LOGGER.warn(" computeWindowSeconds not set");
        }
        resultBits.append(this.computeWindowSeconds.encodeBinary());
        if (this.tagAgeIntervalSeconds == null) {
            LOGGER.warn(" tagAgeIntervalSeconds not set");
        }
        resultBits.append(this.tagAgeIntervalSeconds.encodeBinary());
        if (this.updateIntervalSeconds == null) {
            LOGGER.warn(" updateIntervalSeconds not set");
        }
        resultBits.append(this.updateIntervalSeconds.encodeBinary());
        if (this.impinjDisabledAntennas != null) {
            LOGGER.info(" impinjDisabledAntennas not set");
            resultBits.append(this.impinjDisabledAntennas.encodeBinary());
        }
        if (this.impinjLocationAlgorithmControl != null) {
            LOGGER.info(" impinjLocationAlgorithmControl not set");
            resultBits.append(this.impinjLocationAlgorithmControl.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28");
        Element element = new Element(name, ns);
        if (this.computeWindowSeconds == null) {
            LOGGER.warn(" computeWindowSeconds not set");
            throw new MissingParameterException(" computeWindowSeconds not set");
        }
        element.addContent(this.computeWindowSeconds.encodeXML("ComputeWindowSeconds", ns));
        if (this.tagAgeIntervalSeconds == null) {
            LOGGER.warn(" tagAgeIntervalSeconds not set");
            throw new MissingParameterException(" tagAgeIntervalSeconds not set");
        }
        element.addContent(this.tagAgeIntervalSeconds.encodeXML("TagAgeIntervalSeconds", ns));
        if (this.updateIntervalSeconds == null) {
            LOGGER.warn(" updateIntervalSeconds not set");
            throw new MissingParameterException(" updateIntervalSeconds not set");
        }
        element.addContent(this.updateIntervalSeconds.encodeXML("UpdateIntervalSeconds", ns));
        if (this.impinjDisabledAntennas == null) {
            LOGGER.info("impinjDisabledAntennas not set");
        } else {
            element.addContent(this.impinjDisabledAntennas.encodeXML(this.impinjDisabledAntennas.getClass().getSimpleName(), ns));
        }
        if (this.impinjLocationAlgorithmControl == null) {
            LOGGER.info("impinjLocationAlgorithmControl not set");
        } else {
            element.addContent(this.impinjLocationAlgorithmControl.encodeXML(this.impinjLocationAlgorithmControl.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.computeWindowSeconds = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.tagAgeIntervalSeconds = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        this.updateIntervalSeconds = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        if ((position += UnsignedShort.length()) < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDisabledAntennas.VENDOR_ID) && subType.equals(ImpinjDisabledAntennas.PARAMETER_SUBTYPE)) {
                    this.impinjDisabledAntennas = new ImpinjDisabledAntennas(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjLocationAlgorithmControl.VENDOR_ID) && subType.equals(ImpinjLocationAlgorithmControl.PARAMETER_SUBTYPE)) {
                    this.impinjLocationAlgorithmControl = new ImpinjLocationAlgorithmControl(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ComputeWindowSeconds", element.getNamespace());
        if (temp != null) {
            this.computeWindowSeconds = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("TagAgeIntervalSeconds", element.getNamespace())) != null) {
            this.tagAgeIntervalSeconds = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("UpdateIntervalSeconds", element.getNamespace())) != null) {
            this.updateIntervalSeconds = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("ImpinjDisabledAntennas", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDisabledAntennas", llrpns);
        }
        if (temp != null) {
            this.impinjDisabledAntennas = new ImpinjDisabledAntennas(temp);
            LOGGER.info("setting parameter impinjDisabledAntennas for parameter ImpinjLocationConfig");
        } else {
            LOGGER.info("ImpinjLocationConfig misses non optional parameter of type impinjDisabledAntennas");
        }
        temp = element.getChild("ImpinjLocationAlgorithmControl", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjLocationAlgorithmControl", llrpns);
        }
        if (temp != null) {
            this.impinjLocationAlgorithmControl = new ImpinjLocationAlgorithmControl(temp);
            LOGGER.info("setting parameter impinjLocationAlgorithmControl for parameter ImpinjLocationConfig");
        } else {
            LOGGER.info("ImpinjLocationConfig misses non optional parameter of type impinjLocationAlgorithmControl");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjLocationConfig misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setComputeWindowSeconds(UnsignedShort computeWindowSeconds) {
        this.computeWindowSeconds = computeWindowSeconds;
    }

    public void setTagAgeIntervalSeconds(UnsignedShort tagAgeIntervalSeconds) {
        this.tagAgeIntervalSeconds = tagAgeIntervalSeconds;
    }

    public void setUpdateIntervalSeconds(UnsignedShort updateIntervalSeconds) {
        this.updateIntervalSeconds = updateIntervalSeconds;
    }

    public void setImpinjDisabledAntennas(ImpinjDisabledAntennas impinjDisabledAntennas) {
        this.impinjDisabledAntennas = impinjDisabledAntennas;
    }

    public void setImpinjLocationAlgorithmControl(ImpinjLocationAlgorithmControl impinjLocationAlgorithmControl) {
        this.impinjLocationAlgorithmControl = impinjLocationAlgorithmControl;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getComputeWindowSeconds() {
        return this.computeWindowSeconds;
    }

    public UnsignedShort getTagAgeIntervalSeconds() {
        return this.tagAgeIntervalSeconds;
    }

    public UnsignedShort getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public ImpinjDisabledAntennas getImpinjDisabledAntennas() {
        return this.impinjDisabledAntennas;
    }

    public ImpinjLocationAlgorithmControl getImpinjLocationAlgorithmControl() {
        return this.impinjLocationAlgorithmControl;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

