/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.impinj.octane.CommunicationsStandardType;
import com.impinj.octane.ReaderMode;
import com.impinj.octane.ReaderModel;
import com.impinj.octane.ReaderModesLookup;
import com.impinj.octane.RxSensitivityTableEntry;
import com.impinj.octane.TxPowerTableEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.llrp.ltk.generated.custom.parameters.ImpinjDetailedVersion;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES_RESPONSE;
import org.llrp.ltk.generated.parameters.ReceiveSensitivityTableEntry;
import org.llrp.ltk.generated.parameters.TransmitPowerLevelTableEntry;
import org.llrp.ltk.types.UnsignedIntegerArray;

public class FeatureSet {
    protected List<Double> txFrequencies;
    private long antennaCount;
    private int gpiCount;
    private int gpoCount;
    private int modelNumber;
    private String modelName;
    private ReaderModel readerModel;
    private String serialNumber;
    private String firmwareVersion;
    private int maxOperationSequences;
    private int maxOperationsPerSequence;
    private CommunicationsStandardType communicationsStandard;
    private boolean tagAccessAvailable;
    private boolean filteringAvailable;
    private boolean gpiDebounceAvailable;
    private boolean linkMonitorAvailable;
    private boolean multiwordBlockWriteAvailable;
    private boolean phaseAngleReportingAvailable;
    private boolean fastIdAvailable;
    private boolean impinjRssiReportingAvailable;
    private List<TxPowerTableEntry> txPowers;
    private List<RxSensitivityTableEntry> rxSensitivities;
    private List<ReaderMode> readerModes;
    private boolean hoppingRegion;

    protected FeatureSet() {
    }

    protected FeatureSet(GET_READER_CAPABILITIES_RESPONSE capabilities) {
        this.antennaCount = capabilities.getGeneralDeviceCapabilities().getMaxNumberOfAntennaSupported().toShort();
        this.firmwareVersion = capabilities.getGeneralDeviceCapabilities().getReaderFirmwareVersion().toString();
        this.gpiCount = capabilities.getGeneralDeviceCapabilities().getGPIOCapabilities().getNumGPIs().intValue();
        this.gpoCount = capabilities.getGeneralDeviceCapabilities().getGPIOCapabilities().getNumGPOs().intValue();
        this.maxOperationSequences = capabilities.getLLRPCapabilities().getMaxNumAccessSpecs().intValue();
        this.maxOperationsPerSequence = capabilities.getLLRPCapabilities().getMaxNumOpSpecsPerAccessSpec().intValue();
        this.modelNumber = capabilities.getGeneralDeviceCapabilities().getModelName().intValue();
        this.readerModel = ReaderModel.valueOf(this.modelNumber);
        this.hoppingRegion = capabilities.getRegulatoryCapabilities().getUHFBandCapabilities().getFrequencyInformation().getHopping().toBoolean();
        this.communicationsStandard = CommunicationsStandardType.fromIntValue(capabilities.getRegulatoryCapabilities().getCommunicationsStandard().intValue());
        this.readerModes = ReaderModesLookup.getCompatibleReaderModes(this.readerModel, this.communicationsStandard);
        for (int i = 0; i < capabilities.getCustomList().size(); ++i) {
            if (capabilities.getCustomList().get(i).getClass() != ImpinjDetailedVersion.class) continue;
            ImpinjDetailedVersion detailedVersion = (ImpinjDetailedVersion)capabilities.getCustomList().get(i);
            this.modelName = detailedVersion.getModelName().toString();
            this.serialNumber = detailedVersion.getSerialNumber().toString();
        }
        this.BuildRxTxTables(capabilities);
        this.BuildFreqHopTable(capabilities);
    }

    public static FeatureSet load(String path) throws IOException {
        Gson gson = new Gson();
        BufferedReader br = new BufferedReader(new FileReader(path));
        FeatureSet featuresSetObject = gson.fromJson((Reader)br, FeatureSet.class);
        return featuresSetObject;
    }

    public long getAntennaCount() {
        return this.antennaCount;
    }

    protected void setAntennaCount(long antennaCount) {
        this.antennaCount = antennaCount;
    }

    public int getGpiCount() {
        return this.gpiCount;
    }

    protected void setGpiCount(int gpiCount) {
        this.gpiCount = gpiCount;
    }

    public int getGpoCount() {
        return this.gpoCount;
    }

    protected void setGpoCount(int gpoCount) {
        this.gpoCount = gpoCount;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    protected void setModelNumber(int modelNumber) {
        this.modelNumber = modelNumber;
    }

    public ReaderModel getReaderModel() {
        return this.readerModel;
    }

    protected void setReaderModel(ReaderModel readerModel) {
        this.readerModel = readerModel;
    }

    public String getModelName() {
        return this.modelName;
    }

    protected void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    protected void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    protected void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public int getMaxOperationSequences() {
        return this.maxOperationSequences;
    }

    protected void setMaxOperationSequences(int maxOperationSequences) {
        this.maxOperationSequences = maxOperationSequences;
    }

    public int getMaxOperationsPerSequence() {
        return this.maxOperationsPerSequence;
    }

    protected void setMaxOperationsPerSequence(int maxOperationsPerSequence) {
        this.maxOperationsPerSequence = maxOperationsPerSequence;
    }

    public boolean isTagAccessAvailable() {
        return this.tagAccessAvailable;
    }

    protected void setTagAccessAvailable(boolean tagAccessAvailable) {
        this.tagAccessAvailable = tagAccessAvailable;
    }

    public boolean isFilteringAvailable() {
        return this.filteringAvailable;
    }

    protected void setFilteringAvailable(boolean filteringAvailable) {
        this.filteringAvailable = filteringAvailable;
    }

    public boolean isGpiDebounceAvailable() {
        return this.gpiDebounceAvailable;
    }

    protected void setGpiDebounceAvailable(boolean gpiDebounceAvailable) {
        this.gpiDebounceAvailable = gpiDebounceAvailable;
    }

    public boolean isLinkMonitorAvailable() {
        return this.linkMonitorAvailable;
    }

    protected void setLinkMonitorAvailable(boolean linkMonitorAvailable) {
        this.linkMonitorAvailable = linkMonitorAvailable;
    }

    public boolean isMultiwordBlockWriteAvailable() {
        return this.multiwordBlockWriteAvailable;
    }

    protected void setMultiwordBlockWriteAvailable(boolean multiwordBlockWriteAvailable) {
        this.multiwordBlockWriteAvailable = multiwordBlockWriteAvailable;
    }

    public boolean isPhaseAngleReportingAvailable() {
        return this.phaseAngleReportingAvailable;
    }

    public void setPhaseAngleReportingAvailable(boolean phaseAngleReportingAvailable) {
        this.phaseAngleReportingAvailable = phaseAngleReportingAvailable;
    }

    public boolean isFastIdAvailable() {
        return this.fastIdAvailable;
    }

    protected void setFastIdAvailable(boolean fastIdAvailable) {
        this.fastIdAvailable = fastIdAvailable;
    }

    public boolean isImpinjRssiReportingAvailable() {
        return this.impinjRssiReportingAvailable;
    }

    protected void setImpinjRssiReportingAvailable(boolean impinjRssiReportingAvailable) {
        this.impinjRssiReportingAvailable = impinjRssiReportingAvailable;
    }

    public List<TxPowerTableEntry> getTxPowers() {
        return this.txPowers;
    }

    protected void setTxPowers(List<TxPowerTableEntry> txPowers) {
        this.txPowers = txPowers;
    }

    public List<RxSensitivityTableEntry> getRxSensitivities() {
        return this.rxSensitivities;
    }

    protected void setRxSensitivities(List<RxSensitivityTableEntry> rxSensitivities) {
        this.rxSensitivities = rxSensitivities;
    }

    public boolean isHoppingRegion() {
        return this.hoppingRegion;
    }

    protected void setHoppingRegion(boolean hoppingRegion) {
        this.hoppingRegion = hoppingRegion;
    }

    public List<ReaderMode> getReaderModes() {
        return this.readerModes;
    }

    protected void setReaderModes(List<ReaderMode> readerModes) {
        this.readerModes = readerModes;
    }

    public List<Double> getTxFrequencies() {
        return this.txFrequencies;
    }

    protected void setTxFrequencies(List<Double> txFrequencies) {
        this.txFrequencies = txFrequencies;
    }

    private void BuildFreqHopTable(GET_READER_CAPABILITIES_RESPONSE capabilities) {
        this.txFrequencies = new ArrayList<Double>();
        UnsignedIntegerArray freqs = this.hoppingRegion ? capabilities.getRegulatoryCapabilities().getUHFBandCapabilities().getFrequencyInformation().getFrequencyHopTableList().get(0).getFrequency() : capabilities.getRegulatoryCapabilities().getUHFBandCapabilities().getFrequencyInformation().getFixedFrequencyTable().getFrequency();
        this.txFrequencies.clear();
        for (int i = 0; i < freqs.size(); ++i) {
            this.txFrequencies.add(freqs.get(i).toInteger().doubleValue() / 1000.0);
        }
    }

    private void BuildRxTxTables(GET_READER_CAPABILITIES_RESPONSE capabilities) {
        this.txPowers = new ArrayList<TxPowerTableEntry>();
        this.rxSensitivities = new ArrayList<RxSensitivityTableEntry>();
        this.rxSensitivities.clear();
        int len = capabilities.getGeneralDeviceCapabilities().getReceiveSensitivityTableEntryList().size();
        List<ReceiveSensitivityTableEntry> rxEntries = capabilities.getGeneralDeviceCapabilities().getReceiveSensitivityTableEntryList();
        for (ReceiveSensitivityTableEntry entry : rxEntries) {
            RxSensitivityTableEntry rxEntry = new RxSensitivityTableEntry();
            rxEntry.Dbm = -80.0 + (double)entry.getReceiveSensitivityValue().toShort();
            rxEntry.Index = entry.getIndex();
            this.rxSensitivities.add(rxEntry);
        }
        this.txPowers.clear();
        len = capabilities.getRegulatoryCapabilities().getUHFBandCapabilities().getTransmitPowerLevelTableEntryList().size();
        List<TransmitPowerLevelTableEntry> txEntries = capabilities.getRegulatoryCapabilities().getUHFBandCapabilities().getTransmitPowerLevelTableEntryList();
        for (TransmitPowerLevelTableEntry entry : txEntries) {
            TxPowerTableEntry txEntry = new TxPowerTableEntry();
            txEntry.Dbm = (double)entry.getTransmitPowerValue().toShort() / 100.0;
            txEntry.Index = entry.getIndex();
            this.txPowers.add(txEntry);
        }
    }

    public void save(String path) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String output = gson.toJson(this);
        File file = new File(path);
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(output);
        out.close();
    }
}

