/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjAntennaPolarizationType;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjAntennaPolarizationCapability
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1564);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAntennaPolarizationCapability.class);
    protected ImpinjAntennaPolarizationType type;
    protected UnsignedShort antennaIDOffset;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAntennaPolarizationCapability() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAntennaPolarizationCapability(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAntennaPolarizationCapability(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1564);
        this.decodeXML(element);
    }

    public ImpinjAntennaPolarizationCapability(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.type == null) {
            LOGGER.warn(" type not set");
        }
        resultBits.append(this.type.encodeBinary());
        if (this.antennaIDOffset == null) {
            LOGGER.warn(" antennaIDOffset not set");
        }
        resultBits.append(this.antennaIDOffset.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28");
        Element element = new Element(name, ns);
        if (this.type == null) {
            LOGGER.warn(" type not set");
            throw new MissingParameterException(" type not set");
        }
        element.addContent(this.type.encodeXML("Type", ns));
        if (this.antennaIDOffset == null) {
            LOGGER.warn(" antennaIDOffset not set");
            throw new MissingParameterException(" antennaIDOffset not set");
        }
        element.addContent(this.antennaIDOffset.encodeXML("AntennaIDOffset", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.type = new ImpinjAntennaPolarizationType(binary.subList(position, ImpinjAntennaPolarizationType.length()));
        this.antennaIDOffset = new UnsignedShort(binary.subList(position += ImpinjAntennaPolarizationType.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("Type", element.getNamespace());
        if (temp != null) {
            this.type = new ImpinjAntennaPolarizationType(temp);
        }
        if ((temp = element.getChild("AntennaIDOffset", element.getNamespace())) != null) {
            this.antennaIDOffset = new UnsignedShort(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAntennaPolarizationCapability misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setType(ImpinjAntennaPolarizationType type) {
        this.type = type;
    }

    public void setAntennaIDOffset(UnsignedShort antennaIDOffset) {
        this.antennaIDOffset = antennaIDOffset;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjAntennaPolarizationType getType() {
        return this.type;
    }

    public UnsignedShort getAntennaIDOffset() {
        return this.antennaIDOffset;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

