/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedLong;

public class ImpinjBeaconConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1523);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjBeaconConfiguration.class);
    protected Bit beaconState;
    private BitList reserved0 = new BitList(7);
    protected UnsignedLong beaconDurationSeconds;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjBeaconConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjBeaconConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjBeaconConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1523);
        this.decodeXML(element);
    }

    public ImpinjBeaconConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.beaconState == null) {
            LOGGER.warn(" beaconState not set");
        }
        resultBits.append(this.beaconState.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.beaconDurationSeconds == null) {
            LOGGER.warn(" beaconDurationSeconds not set");
        }
        resultBits.append(this.beaconDurationSeconds.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28");
        Element element = new Element(name, ns);
        if (this.beaconState == null) {
            LOGGER.warn(" beaconState not set");
            throw new MissingParameterException(" beaconState not set");
        }
        element.addContent(this.beaconState.encodeXML("BeaconState", ns));
        if (this.beaconDurationSeconds == null) {
            LOGGER.warn(" beaconDurationSeconds not set");
            throw new MissingParameterException(" beaconDurationSeconds not set");
        }
        element.addContent(this.beaconDurationSeconds.encodeXML("BeaconDurationSeconds", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.beaconState = new Bit(binary.subList(position, Bit.length()));
        position += Bit.length();
        this.beaconDurationSeconds = new UnsignedLong(binary.subList(position += this.reserved0.length(), UnsignedLong.length()));
        position += UnsignedLong.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("BeaconState", element.getNamespace());
        if (temp != null) {
            this.beaconState = new Bit(temp);
        }
        if ((temp = element.getChild("BeaconDurationSeconds", element.getNamespace())) != null) {
            this.beaconDurationSeconds = new UnsignedLong(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjBeaconConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setBeaconState(Bit beaconState) {
        this.beaconState = beaconState;
    }

    public void setBeaconDurationSeconds(UnsignedLong beaconDurationSeconds) {
        this.beaconDurationSeconds = beaconDurationSeconds;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public Bit getBeaconState() {
        return this.beaconState;
    }

    public UnsignedLong getBeaconDurationSeconds() {
        return this.beaconDurationSeconds;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

