/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionRFMode;
import org.llrp.ltk.generated.custom.parameters.ImpinjTransmitPower;
import org.llrp.ltk.generated.parameters.C1G2Filter;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjC1G2DirectionConfig
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1571);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjC1G2DirectionConfig.class);
    protected ImpinjDirectionRFMode rFMode;
    private ImpinjTransmitPower impinjTransmitPower;
    private List<C1G2Filter> c1G2FilterList = new LinkedList<C1G2Filter>();
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjC1G2DirectionConfig() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjC1G2DirectionConfig(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjC1G2DirectionConfig(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1571);
        this.decodeXML(element);
    }

    public ImpinjC1G2DirectionConfig(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.rFMode == null) {
            LOGGER.warn(" rFMode not set");
        }
        resultBits.append(this.rFMode.encodeBinary());
        if (this.impinjTransmitPower != null) {
            LOGGER.info(" impinjTransmitPower not set");
            resultBits.append(this.impinjTransmitPower.encodeBinary());
        }
        if (this.c1G2FilterList == null) {
            LOGGER.info(" c1G2FilterList not set");
        } else {
            for (C1G2Filter c1G2Filter : this.c1G2FilterList) {
                resultBits.append(c1G2Filter.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28");
        Element element = new Element(name, ns);
        if (this.rFMode == null) {
            LOGGER.warn(" rFMode not set");
            throw new MissingParameterException(" rFMode not set");
        }
        element.addContent(this.rFMode.encodeXML("RFMode", ns));
        if (this.impinjTransmitPower == null) {
            LOGGER.info("impinjTransmitPower not set");
        } else {
            element.addContent(this.impinjTransmitPower.encodeXML(this.impinjTransmitPower.getClass().getSimpleName(), ns));
        }
        if (this.c1G2FilterList == null) {
            LOGGER.info("c1G2FilterList not set");
        } else {
            for (C1G2Filter c1G2Filter : this.c1G2FilterList) {
                element.addContent(c1G2Filter.encodeXML(c1G2Filter.getClass().getName().replaceAll(c1G2Filter.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.rFMode = new ImpinjDirectionRFMode(binary.subList(position, ImpinjDirectionRFMode.length()));
        if ((position += ImpinjDirectionRFMode.length()) < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                UnsignedInteger subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjTransmitPower.VENDOR_ID) && subType.equals(ImpinjTransmitPower.PARAMETER_SUBTYPE)) {
                    this.impinjTransmitPower = new ImpinjTransmitPower(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.c1G2FilterList = new LinkedList<C1G2Filter>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (!_type.equals(C1G2Filter.TYPENUM)) break;
            this.c1G2FilterList.add(new C1G2Filter(binary.subList(position, tempLength)));
            position += tempLength;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("RFMode", element.getNamespace());
        if (temp != null) {
            this.rFMode = new ImpinjDirectionRFMode(temp);
        }
        if ((temp = element.getChild("ImpinjTransmitPower", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjTransmitPower", (Namespace)llrpns);
        }
        if (temp != null) {
            this.impinjTransmitPower = new ImpinjTransmitPower(temp);
            LOGGER.info("setting parameter impinjTransmitPower for parameter ImpinjC1G2DirectionConfig");
        } else {
            LOGGER.info("ImpinjC1G2DirectionConfig misses non optional parameter of type impinjTransmitPower");
        }
        this.c1G2FilterList = new LinkedList<C1G2Filter>();
        tempList = element.getChildren("C1G2Filter", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("C1G2Filter", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjC1G2DirectionConfig misses optional parameter of type c1G2FilterList");
        } else {
            for (Element e : tempList) {
                this.c1G2FilterList.add(new C1G2Filter(e));
                LOGGER.debug("adding C1G2Filter to c1G2FilterList ");
            }
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjC1G2DirectionConfig misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setRFMode(ImpinjDirectionRFMode rFMode) {
        this.rFMode = rFMode;
    }

    public void setImpinjTransmitPower(ImpinjTransmitPower impinjTransmitPower) {
        this.impinjTransmitPower = impinjTransmitPower;
    }

    public void setC1G2FilterList(List<C1G2Filter> c1G2FilterList) {
        this.c1G2FilterList = c1G2FilterList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjDirectionRFMode getRFMode() {
        return this.rFMode;
    }

    public ImpinjTransmitPower getImpinjTransmitPower() {
        return this.impinjTransmitPower;
    }

    public List<C1G2Filter> getC1G2FilterList() {
        return this.c1G2FilterList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToC1G2FilterList(C1G2Filter c1G2Filter) {
        if (this.c1G2FilterList == null) {
            this.c1G2FilterList = new LinkedList<C1G2Filter>();
        }
        this.c1G2FilterList.add(c1G2Filter);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

