/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedIntegerArray;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDirectionDiagnosticData
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1574);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDirectionDiagnosticData.class);
    protected UnsignedIntegerArray metric;

    public ImpinjDirectionDiagnosticData() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDirectionDiagnosticData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDirectionDiagnosticData(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1574);
        this.decodeXML(element);
    }

    public ImpinjDirectionDiagnosticData(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.metric == null) {
            LOGGER.warn(" metric not set");
        }
        resultBits.append(this.metric.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28");
        Element element = new Element(name, ns);
        if (this.metric == null) {
            LOGGER.warn(" metric not set");
            throw new MissingParameterException(" metric not set");
        }
        element.addContent(this.metric.encodeXML("Metric", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        short fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UnsignedIntegerArray.length() * fieldCount + UnsignedShort.length();
        this.metric = new UnsignedIntegerArray(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        Object tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("Metric", element.getNamespace());
        if (temp != null) {
            this.metric = new UnsignedIntegerArray(temp);
        }
    }

    public void setMetric(UnsignedIntegerArray metric) {
        this.metric = metric;
    }

    public UnsignedIntegerArray getMetric() {
        return this.metric;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

