/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.ROSpec;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ADD_ROSPEC
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(20);
    private static final Logger LOGGER = Logger.getLogger(ADD_ROSPEC.class);
    public static final String RESPONSETYPE = "ADD_ROSPEC_RESPONSE";
    protected ROSpec rOSpec;

    public ADD_ROSPEC() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public ADD_ROSPEC(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public ADD_ROSPEC(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public ADD_ROSPEC(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpec == null) {
            LOGGER.warn(" rOSpec not set");
            throw new InvalidLLRPMessageException(" rOSpec not set");
        }
        resultBits.append(this.rOSpec.encodeBinary());
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("ADD_ROSPEC", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.rOSpec == null) {
                LOGGER.info("rOSpec not set");
                throw new MissingParameterException("rOSpec not set");
            }
            root.addContent(this.rOSpec.encodeXML(this.rOSpec.getClass().getSimpleName(), ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("ADD_ROSPEC misses non optional parameter of type ROSpec");
            throw new InvalidLLRPMessageException("ADD_ROSPEC misses non optional parameter of type ROSpec");
        }
        if (binary.get(position)) {
            ADD_ROSPEC aDD_ROSPEC = this;
            tempLength = aDD_ROSPEC.rOSpec.length();
        }
        if (type != null && type.equals(ROSpec.TYPENUM)) {
            this.rOSpec = new ROSpec(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("ADD_ROSPEC misses non optional parameter of type ROSpec");
            throw new InvalidLLRPMessageException("ADD_ROSPEC misses non optional parameter of type ROSpec");
        }
        LOGGER.trace(" rOSpec is instantiated with ROSpec with length" + tempLength);
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("ROSpec", ns);
            if (temp == null) {
                LOGGER.warn("ADD_ROSPEC misses non optional parameter of type rOSpec");
                throw new MissingParameterException("ADD_ROSPEC misses non optional parameter of type rOSpec");
            }
            this.rOSpec = new ROSpec(temp);
            LOGGER.info("setting parameter rOSpec for parameter ADD_ROSPEC");
            root.removeChild("ROSpec", ns);
            if (root.getChildren().size() > 0) {
                String message = "ADD_ROSPEC has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setROSpec(ROSpec rOSpec) {
        this.rOSpec = rOSpec;
    }

    public ROSpec getROSpec() {
        return this.rOSpec;
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "ADD_ROSPEC";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

