/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.LLRPStatus;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class STOP_ROSPEC_RESPONSE
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(33);
    private static final Logger LOGGER = Logger.getLogger(STOP_ROSPEC_RESPONSE.class);
    public static final String RESPONSETYPE = "";
    protected LLRPStatus lLRPStatus;

    public STOP_ROSPEC_RESPONSE() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public STOP_ROSPEC_RESPONSE(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public STOP_ROSPEC_RESPONSE(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public STOP_ROSPEC_RESPONSE(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.lLRPStatus == null) {
            LOGGER.warn(" lLRPStatus not set");
            throw new InvalidLLRPMessageException(" lLRPStatus not set");
        }
        resultBits.append(this.lLRPStatus.encodeBinary());
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("STOP_ROSPEC_RESPONSE", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.28"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.lLRPStatus == null) {
                LOGGER.info("lLRPStatus not set");
                throw new MissingParameterException("lLRPStatus not set");
            }
            root.addContent(this.lLRPStatus.encodeXML(this.lLRPStatus.getClass().getSimpleName(), ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("STOP_ROSPEC_RESPONSE misses non optional parameter of type LLRPStatus");
            throw new InvalidLLRPMessageException("STOP_ROSPEC_RESPONSE misses non optional parameter of type LLRPStatus");
        }
        if (binary.get(position)) {
            STOP_ROSPEC_RESPONSE sTOP_ROSPEC_RESPONSE = this;
            tempLength = sTOP_ROSPEC_RESPONSE.lLRPStatus.length();
        }
        if (type != null && type.equals(LLRPStatus.TYPENUM)) {
            this.lLRPStatus = new LLRPStatus(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("STOP_ROSPEC_RESPONSE misses non optional parameter of type LLRPStatus");
            throw new InvalidLLRPMessageException("STOP_ROSPEC_RESPONSE misses non optional parameter of type LLRPStatus");
        }
        LOGGER.trace(" lLRPStatus is instantiated with LLRPStatus with length" + tempLength);
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("LLRPStatus", ns);
            if (temp == null) {
                LOGGER.warn("STOP_ROSPEC_RESPONSE misses non optional parameter of type lLRPStatus");
                throw new MissingParameterException("STOP_ROSPEC_RESPONSE misses non optional parameter of type lLRPStatus");
            }
            this.lLRPStatus = new LLRPStatus(temp);
            LOGGER.info("setting parameter lLRPStatus for parameter STOP_ROSPEC_RESPONSE");
            root.removeChild("LLRPStatus", ns);
            if (root.getChildren().size() > 0) {
                String message = "STOP_ROSPEC_RESPONSE has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setLLRPStatus(LLRPStatus lLRPStatus) {
        this.lLRPStatus = lLRPStatus;
    }

    public LLRPStatus getLLRPStatus() {
        return this.lLRPStatus;
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "STOP_ROSPEC_RESPONSE";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

