/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolInventoryCommandSettings;
import org.llrp.ltk.generated.parameters.C1G2InventoryCommand;
import org.llrp.ltk.generated.parameters.RFReceiver;
import org.llrp.ltk.generated.parameters.RFTransmitter;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class AntennaConfiguration
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(222);
    private static final Logger LOGGER = Logger.getLogger(AntennaConfiguration.class);
    protected UnsignedShort antennaID;
    protected RFReceiver rFReceiver;
    protected RFTransmitter rFTransmitter;
    protected List<AirProtocolInventoryCommandSettings> airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();

    public AntennaConfiguration() {
    }

    public AntennaConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AntennaConfiguration(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AntennaConfiguration(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type AntennaConfiguration");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.rFReceiver == null) {
            LOGGER.info(" rFReceiver not set");
        } else {
            resultBits.append(this.rFReceiver.encodeBinary());
        }
        if (this.rFTransmitter == null) {
            LOGGER.info(" rFTransmitter not set");
        } else {
            resultBits.append(this.rFTransmitter.encodeBinary());
        }
        if (this.airProtocolInventoryCommandSettingsList == null) {
            LOGGER.info(" airProtocolInventoryCommandSettingsList not set");
        } else {
            for (AirProtocolInventoryCommandSettings field : this.airProtocolInventoryCommandSettingsList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.rFReceiver == null) {
            LOGGER.info("rFReceiver not set");
        } else {
            element.addContent(this.rFReceiver.encodeXML(this.rFReceiver.getClass().getSimpleName(), ns));
        }
        if (this.rFTransmitter == null) {
            LOGGER.info("rFTransmitter not set");
        } else {
            element.addContent(this.rFTransmitter.encodeXML(this.rFTransmitter.getClass().getSimpleName(), ns));
        }
        if (this.airProtocolInventoryCommandSettingsList == null) {
            LOGGER.info("airProtocolInventoryCommandSettingsList not set");
        } else {
            for (AirProtocolInventoryCommandSettings field : this.airProtocolInventoryCommandSettingsList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.antennaID = new UnsignedShort(binary, position, UnsignedShort.length());
        position += UnsignedShort.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type RFReceiver");
        }
        if (binary.get(position)) {
            AntennaConfiguration antennaConfiguration = this;
            tempLength = antennaConfiguration.rFReceiver.length();
        }
        if (type != null && type.equals(RFReceiver.TYPENUM)) {
            this.rFReceiver = new RFReceiver(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" rFReceiver is instantiated with RFReceiver with length" + tempLength);
        } else {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type RFReceiver");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type RFTransmitter");
        }
        if (binary.get(position)) {
            AntennaConfiguration antennaConfiguration = this;
            tempLength = antennaConfiguration.rFTransmitter.length();
        }
        if (type != null && type.equals(RFTransmitter.TYPENUM)) {
            this.rFTransmitter = new RFTransmitter(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" rFTransmitter is instantiated with RFTransmitter with length" + tempLength);
        } else {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type RFTransmitter");
        }
        this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        LOGGER.trace("decoding parameter airProtocolInventoryCommandSettingsList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2InventoryCommand.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2InventoryCommand.length();
                }
                this.airProtocolInventoryCommandSettingsList.add(new C1G2InventoryCommand(binary, position, tempLength));
                LOGGER.trace("adding C1G2InventoryCommand to airProtocolInventoryCommandSettingsList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (foundOne) continue;
            break;
        }
        if (this.airProtocolInventoryCommandSettingsList.isEmpty()) {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type AirProtocolInventoryCommandSettings");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("RFReceiver", ns);
        if (temp != null) {
            this.rFReceiver = new RFReceiver(temp);
            LOGGER.info("setting parameter rFReceiver for parameter AntennaConfiguration");
        }
        if (temp == null) {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type rFReceiver");
        }
        element.removeChild("RFReceiver", ns);
        temp = element.getChild("RFTransmitter", ns);
        if (temp != null) {
            this.rFTransmitter = new RFTransmitter(temp);
            LOGGER.info("setting parameter rFTransmitter for parameter AntennaConfiguration");
        }
        if (temp == null) {
            LOGGER.trace("AntennaConfiguration misses optional parameter of type rFTransmitter");
        }
        element.removeChild("RFTransmitter", ns);
        this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (!name.equals("C1G2InventoryCommand")) continue;
            this.airProtocolInventoryCommandSettingsList.add(new C1G2InventoryCommand(e));
            LOGGER.trace("adding C1G2InventoryCommand to airProtocolInventoryCommandSettingsList ");
            atLeastOnce = true;
            i.remove();
        }
        if (element.getChildren().size() > 0) {
            String message = "AntennaConfiguration has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setRFReceiver(RFReceiver rFReceiver) {
        this.rFReceiver = rFReceiver;
    }

    public void setRFTransmitter(RFTransmitter rFTransmitter) {
        this.rFTransmitter = rFTransmitter;
    }

    public void setAirProtocolInventoryCommandSettingsList(List<AirProtocolInventoryCommandSettings> airProtocolInventoryCommandSettingsList) {
        this.airProtocolInventoryCommandSettingsList = airProtocolInventoryCommandSettingsList;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public RFReceiver getRFReceiver() {
        return this.rFReceiver;
    }

    public RFTransmitter getRFTransmitter() {
        return this.rFTransmitter;
    }

    public List<AirProtocolInventoryCommandSettings> getAirProtocolInventoryCommandSettingsList() {
        return this.airProtocolInventoryCommandSettingsList;
    }

    public void addToAirProtocolInventoryCommandSettingsList(AirProtocolInventoryCommandSettings airProtocolInventoryCommandSettings) {
        if (this.airProtocolInventoryCommandSettingsList == null) {
            this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        }
        this.airProtocolInventoryCommandSettingsList.add(airProtocolInventoryCommandSettings);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AntennaConfiguration";
    }

    public String toString() {
        String result = "AntennaConfiguration: ";
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

