/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class RFReceiver
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(223);
    private static final Logger LOGGER = Logger.getLogger(RFReceiver.class);
    protected UnsignedShort receiverSensitivity;

    public RFReceiver() {
    }

    public RFReceiver(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RFReceiver(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public RFReceiver(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.receiverSensitivity == null) {
            LOGGER.warn(" receiverSensitivity not set");
            throw new MissingParameterException(" receiverSensitivity not set  for Parameter of Type RFReceiver");
        }
        resultBits.append(this.receiverSensitivity.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.receiverSensitivity == null) {
            LOGGER.warn(" receiverSensitivity not set");
            throw new MissingParameterException(" receiverSensitivity not set");
        }
        element.addContent(this.receiverSensitivity.encodeXML("ReceiverSensitivity", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.receiverSensitivity = new UnsignedShort(binary, position, UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ReceiverSensitivity", ns);
        if (temp != null) {
            this.receiverSensitivity = new UnsignedShort(temp);
        }
        element.removeChild("ReceiverSensitivity", ns);
        if (element.getChildren().size() > 0) {
            String message = "RFReceiver has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setReceiverSensitivity(UnsignedShort receiverSensitivity) {
        this.receiverSensitivity = receiverSensitivity;
    }

    public UnsignedShort getReceiverSensitivity() {
        return this.receiverSensitivity;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "RFReceiver";
    }

    public String toString() {
        String result = "RFReceiver: ";
        result = result + ", receiverSensitivity: ";
        result = result + this.receiverSensitivity;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

