/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.TagModelName;

public class TagModelDetails {
    private TagModelName modelName;
    private short userMemorySizeBits;
    private short epcSizeBits;
    private boolean supportsQt;

    protected TagModelDetails() {
        this.SetDefaults();
    }

    protected TagModelDetails(String tid) {
        String w1 = tid.substring(0, 4).toUpperCase();
        String w2 = tid.substring(4, 8).toUpperCase();
        Integer w2Int = Integer.parseInt(w2, 16);
        TagModelName tagModelName = TagModelName.valueOf(w2Int);
        this.SetDefaults();
        if (w1.equals("E280")) {
            switch (tagModelName) {
                case Monza4QT: {
                    this.modelName = TagModelName.Monza4QT;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)512;
                    this.supportsQt = true;
                    break;
                }
                case Monza4U: {
                    this.modelName = TagModelName.Monza4U;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)512;
                    this.supportsQt = false;
                    break;
                }
                case Monza4E: {
                    this.modelName = TagModelName.Monza4E;
                    this.epcSizeBits = (short)496;
                    this.userMemorySizeBits = (short)128;
                    this.supportsQt = false;
                    break;
                }
                case Monza4D: {
                    this.modelName = TagModelName.Monza4D;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)32;
                    this.supportsQt = false;
                    break;
                }
                case Monza5: {
                    this.modelName = TagModelName.Monza5;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = 0;
                    this.supportsQt = false;
                    break;
                }
                case Monza5U: {
                    this.modelName = TagModelName.Monza5U;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)32;
                    this.supportsQt = false;
                    break;
                }
                case MonzaX_2K_Dura: {
                    this.modelName = TagModelName.MonzaX_2K_Dura;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)2176;
                    this.supportsQt = true;
                    break;
                }
                case MonzaX_8K_Dura: {
                    this.modelName = TagModelName.MonzaX_8K_Dura;
                    this.epcSizeBits = (short)128;
                    this.userMemorySizeBits = (short)8192;
                    this.supportsQt = true;
                    break;
                }
                case MonzaR6: {
                    this.modelName = TagModelName.MonzaR6;
                    this.epcSizeBits = (short)96;
                    this.userMemorySizeBits = 0;
                    this.supportsQt = false;
                    break;
                }
                case MonzaR6_P: {
                    this.modelName = TagModelName.MonzaR6_P;
                    this.epcSizeBits = 0;
                    this.userMemorySizeBits = 0;
                    this.supportsQt = false;
                    break;
                }
                case MonzaS6_C: {
                    this.modelName = TagModelName.MonzaS6_C;
                    this.epcSizeBits = (short)96;
                    this.userMemorySizeBits = (short)32;
                    this.supportsQt = false;
                    break;
                }
                case MonzaR6_A: {
                    this.modelName = TagModelName.MonzaR6_A;
                    this.epcSizeBits = (short)96;
                    this.userMemorySizeBits = 0;
                    this.supportsQt = false;
                    break;
                }
                default: {
                    this.modelName = TagModelName.Other;
                    this.epcSizeBits = 0;
                    this.userMemorySizeBits = 0;
                    this.supportsQt = false;
                }
            }
        }
    }

    private void SetDefaults() {
        this.modelName = TagModelName.Other;
        this.epcSizeBits = 0;
        this.userMemorySizeBits = 0;
        this.supportsQt = false;
    }

    public TagModelName getModelName() {
        return this.modelName;
    }

    public short getUserMemorySizeBits() {
        return this.userMemorySizeBits;
    }

    public short getEpcSizeBits() {
        return this.epcSizeBits;
    }

    public boolean isSupportsQt() {
        return this.supportsQt;
    }
}

