/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.CommunicationsStandardType;
import com.impinj.octane.ReaderMode;
import com.impinj.octane.ReaderModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class ReaderModesLookup {
    private static final HashMap<ReaderModel, List<ReaderMode>> ReaderModelToReaderModes = new HashMap();
    private static final HashMap<CommunicationsStandardType, List<ReaderMode>> CommunicationToReaderModes = new HashMap();

    ReaderModesLookup() {
    }

    static List<ReaderMode> getCompatibleReaderModes(ReaderModel readerModel, CommunicationsStandardType communicationsStandardType) {
        List<Object> modelReaderModes = ReaderModelToReaderModes.containsKey((Object)readerModel) ? ReaderModelToReaderModes.get((Object)readerModel) : new ArrayList();
        List<Object> commStandardTypeReaderModes = CommunicationToReaderModes.containsKey((Object)communicationsStandardType) ? CommunicationToReaderModes.get((Object)communicationsStandardType) : new ArrayList();
        ArrayList<ReaderMode> readerModes = new ArrayList<ReaderMode>(Math.max(modelReaderModes.size(), commStandardTypeReaderModes.size()));
        readerModes.addAll(modelReaderModes);
        readerModes.retainAll(commStandardTypeReaderModes);
        return readerModes;
    }

    static {
        ReaderModelToReaderModes.put(ReaderModel.SpeedwayR120, Arrays.asList(ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader));
        ReaderModelToReaderModes.put(ReaderModel.SpeedwayR220, Arrays.asList(ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader));
        ReaderModelToReaderModes.put(ReaderModel.SpeedwayR420, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        ReaderModelToReaderModes.put(ReaderModel.XPortal, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        ReaderModelToReaderModes.put(ReaderModel.XArrayWM, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        ReaderModelToReaderModes.put(ReaderModel.XArrayEAP, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        ReaderModelToReaderModes.put(ReaderModel.XArray, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        ReaderModelToReaderModes.put(ReaderModel.XSpan, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.US_FCC_Part_15, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.MaxMiller, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.ETSI_302_208, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.ETSI_300_220, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Australia_LIPD_1W, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Australia_LIPD_4W, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Japan_ARIB_STD_T89, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Hong_Kong_OFTA_1049, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Taiwan_DGT_LP0002, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
        CommunicationToReaderModes.put(CommunicationsStandardType.Korea_MIC_Article_5_2, Arrays.asList(ReaderMode.MaxThroughput, ReaderMode.Hybrid, ReaderMode.DenseReaderM4, ReaderMode.DenseReaderM8, ReaderMode.DenseReaderM4Two, ReaderMode.AutoSetDenseReader, ReaderMode.AutoSetDenseReaderDeepScan, ReaderMode.AutoSetStaticFast, ReaderMode.AutoSetStaticDRM));
    }
}

