/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.messages.IMPINJ_ENABLE_EXTENSIONS;
import org.llrp.ltk.generated.custom.messages.IMPINJ_ENABLE_EXTENSIONS_RESPONSE;
import org.llrp.ltk.generated.custom.messages.IMPINJ_SAVE_SETTINGS;
import org.llrp.ltk.generated.custom.messages.IMPINJ_SAVE_SETTINGS_RESPONSE;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ADD_ROSPEC;
import org.llrp.ltk.generated.messages.ADD_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.CLIENT_REQUEST_OP;
import org.llrp.ltk.generated.messages.CLIENT_REQUEST_OP_RESPONSE;
import org.llrp.ltk.generated.messages.CLOSE_CONNECTION;
import org.llrp.ltk.generated.messages.CLOSE_CONNECTION_RESPONSE;
import org.llrp.ltk.generated.messages.CUSTOM_MESSAGE;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DELETE_ROSPEC;
import org.llrp.ltk.generated.messages.DELETE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DISABLE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.DISABLE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DISABLE_ROSPEC;
import org.llrp.ltk.generated.messages.DISABLE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ENABLE_EVENTS_AND_REPORTS;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ERROR_MESSAGE;
import org.llrp.ltk.generated.messages.GET_ACCESSSPECS;
import org.llrp.ltk.generated.messages.GET_ACCESSSPECS_RESPONSE;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES_RESPONSE;
import org.llrp.ltk.generated.messages.GET_READER_CONFIG;
import org.llrp.ltk.generated.messages.GET_READER_CONFIG_RESPONSE;
import org.llrp.ltk.generated.messages.GET_REPORT;
import org.llrp.ltk.generated.messages.GET_ROSPECS;
import org.llrp.ltk.generated.messages.GET_ROSPECS_RESPONSE;
import org.llrp.ltk.generated.messages.KEEPALIVE;
import org.llrp.ltk.generated.messages.KEEPALIVE_ACK;
import org.llrp.ltk.generated.messages.READER_EVENT_NOTIFICATION;
import org.llrp.ltk.generated.messages.RO_ACCESS_REPORT;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG_RESPONSE;
import org.llrp.ltk.generated.messages.START_ROSPEC;
import org.llrp.ltk.generated.messages.START_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.STOP_ROSPEC;
import org.llrp.ltk.generated.messages.STOP_ROSPEC_RESPONSE;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class LLRPMessageFactory {
    private static final Logger logger = Logger.getLogger("LLRPMessageFactory");
    public static final int reservedLength = 3;
    public static final int versionLength = 3;

    public static LLRPMessage createLLRPMessage(LLRPBitList bits) throws InvalidLLRPMessageException {
        Short messageType = new SignedShort(bits, 6, SignedShort.length() - 6).toShort();
        LLRPMessage message = null;
        if (messageType.shortValue() == RO_ACCESS_REPORT.TYPENUM.intValue()) {
            return new RO_ACCESS_REPORT(bits);
        }
        if (messageType.shortValue() == CUSTOM_MESSAGE.TYPENUM.intValue()) {
            message = new CUSTOM_MESSAGE(bits);
            int subtype = ((CUSTOM_MESSAGE)message).getMessageSubtype().intValue();
            UnsignedInteger vendorID = ((CUSTOM_MESSAGE)message).getVendorIdentifier();
            if (subtype == IMPINJ_ENABLE_EXTENSIONS.subtype.intValue() && vendorID.equals(IMPINJ_ENABLE_EXTENSIONS.vendorIdentifier)) {
                message = new IMPINJ_ENABLE_EXTENSIONS(bits);
            }
            if (subtype == IMPINJ_ENABLE_EXTENSIONS_RESPONSE.subtype.intValue() && vendorID.equals(IMPINJ_ENABLE_EXTENSIONS_RESPONSE.vendorIdentifier)) {
                message = new IMPINJ_ENABLE_EXTENSIONS_RESPONSE(bits);
            }
            if (subtype == IMPINJ_SAVE_SETTINGS.subtype.intValue() && vendorID.equals(IMPINJ_SAVE_SETTINGS.vendorIdentifier)) {
                message = new IMPINJ_SAVE_SETTINGS(bits);
            }
            if (subtype == IMPINJ_SAVE_SETTINGS_RESPONSE.subtype.intValue() && vendorID.equals(IMPINJ_SAVE_SETTINGS_RESPONSE.vendorIdentifier)) {
                message = new IMPINJ_SAVE_SETTINGS_RESPONSE(bits);
            }
        }
        if (messageType.shortValue() == GET_READER_CAPABILITIES.TYPENUM.intValue()) {
            message = new GET_READER_CAPABILITIES(bits);
        }
        if (messageType.shortValue() == GET_READER_CAPABILITIES_RESPONSE.TYPENUM.intValue()) {
            message = new GET_READER_CAPABILITIES_RESPONSE(bits);
        }
        if (messageType.shortValue() == ADD_ROSPEC.TYPENUM.intValue()) {
            message = new ADD_ROSPEC(bits);
        }
        if (messageType.shortValue() == ADD_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new ADD_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == DELETE_ROSPEC.TYPENUM.intValue()) {
            message = new DELETE_ROSPEC(bits);
        }
        if (messageType.shortValue() == DELETE_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new DELETE_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == START_ROSPEC.TYPENUM.intValue()) {
            message = new START_ROSPEC(bits);
        }
        if (messageType.shortValue() == START_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new START_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == STOP_ROSPEC.TYPENUM.intValue()) {
            message = new STOP_ROSPEC(bits);
        }
        if (messageType.shortValue() == STOP_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new STOP_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == ENABLE_ROSPEC.TYPENUM.intValue()) {
            message = new ENABLE_ROSPEC(bits);
        }
        if (messageType.shortValue() == ENABLE_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new ENABLE_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == DISABLE_ROSPEC.TYPENUM.intValue()) {
            message = new DISABLE_ROSPEC(bits);
        }
        if (messageType.shortValue() == DISABLE_ROSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new DISABLE_ROSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == GET_ROSPECS.TYPENUM.intValue()) {
            message = new GET_ROSPECS(bits);
        }
        if (messageType.shortValue() == GET_ROSPECS_RESPONSE.TYPENUM.intValue()) {
            message = new GET_ROSPECS_RESPONSE(bits);
        }
        if (messageType.shortValue() == ADD_ACCESSSPEC.TYPENUM.intValue()) {
            message = new ADD_ACCESSSPEC(bits);
        }
        if (messageType.shortValue() == ADD_ACCESSSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new ADD_ACCESSSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == DELETE_ACCESSSPEC.TYPENUM.intValue()) {
            message = new DELETE_ACCESSSPEC(bits);
        }
        if (messageType.shortValue() == DELETE_ACCESSSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new DELETE_ACCESSSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == ENABLE_ACCESSSPEC.TYPENUM.intValue()) {
            message = new ENABLE_ACCESSSPEC(bits);
        }
        if (messageType.shortValue() == ENABLE_ACCESSSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new ENABLE_ACCESSSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == DISABLE_ACCESSSPEC.TYPENUM.intValue()) {
            message = new DISABLE_ACCESSSPEC(bits);
        }
        if (messageType.shortValue() == DISABLE_ACCESSSPEC_RESPONSE.TYPENUM.intValue()) {
            message = new DISABLE_ACCESSSPEC_RESPONSE(bits);
        }
        if (messageType.shortValue() == GET_ACCESSSPECS.TYPENUM.intValue()) {
            message = new GET_ACCESSSPECS(bits);
        }
        if (messageType.shortValue() == GET_ACCESSSPECS_RESPONSE.TYPENUM.intValue()) {
            message = new GET_ACCESSSPECS_RESPONSE(bits);
        }
        if (messageType.shortValue() == CLIENT_REQUEST_OP.TYPENUM.intValue()) {
            message = new CLIENT_REQUEST_OP(bits);
        }
        if (messageType.shortValue() == CLIENT_REQUEST_OP_RESPONSE.TYPENUM.intValue()) {
            message = new CLIENT_REQUEST_OP_RESPONSE(bits);
        }
        if (messageType.shortValue() == GET_READER_CONFIG.TYPENUM.intValue()) {
            message = new GET_READER_CONFIG(bits);
        }
        if (messageType.shortValue() == GET_READER_CONFIG_RESPONSE.TYPENUM.intValue()) {
            message = new GET_READER_CONFIG_RESPONSE(bits);
        }
        if (messageType.shortValue() == SET_READER_CONFIG.TYPENUM.intValue()) {
            message = new SET_READER_CONFIG(bits);
        }
        if (messageType.shortValue() == SET_READER_CONFIG_RESPONSE.TYPENUM.intValue()) {
            message = new SET_READER_CONFIG_RESPONSE(bits);
        }
        if (messageType.shortValue() == CLOSE_CONNECTION.TYPENUM.intValue()) {
            message = new CLOSE_CONNECTION(bits);
        }
        if (messageType.shortValue() == CLOSE_CONNECTION_RESPONSE.TYPENUM.intValue()) {
            message = new CLOSE_CONNECTION_RESPONSE(bits);
        }
        if (messageType.shortValue() == GET_REPORT.TYPENUM.intValue()) {
            message = new GET_REPORT(bits);
        }
        if (messageType.shortValue() == RO_ACCESS_REPORT.TYPENUM.intValue()) {
            message = new RO_ACCESS_REPORT(bits);
        }
        if (messageType.shortValue() == KEEPALIVE.TYPENUM.intValue()) {
            message = new KEEPALIVE(bits);
        }
        if (messageType.shortValue() == KEEPALIVE_ACK.TYPENUM.intValue()) {
            message = new KEEPALIVE_ACK(bits);
        }
        if (messageType.shortValue() == READER_EVENT_NOTIFICATION.TYPENUM.intValue()) {
            message = new READER_EVENT_NOTIFICATION(bits);
        }
        if (messageType.shortValue() == ENABLE_EVENTS_AND_REPORTS.TYPENUM.intValue()) {
            message = new ENABLE_EVENTS_AND_REPORTS(bits);
        }
        if (messageType.shortValue() == ERROR_MESSAGE.TYPENUM.intValue()) {
            message = new ERROR_MESSAGE(bits);
        }
        if (message == null) {
            throw new InvalidLLRPMessageException("The message type (\"" + messageType + "\") specified in the binary LLRP message is not known.");
        }
        return message;
    }

    public static LLRPMessage createLLRPMessage(byte[] byteArray) throws InvalidLLRPMessageException {
        LLRPBitList bits = new LLRPBitList(byteArray);
        return LLRPMessageFactory.createLLRPMessage(bits);
    }

    public static LLRPMessage createLLRPMessage(Document document) throws InvalidLLRPMessageException {
        Element root = document.getRootElement();
        String className = root.getName();
        if (logger.isTraceEnabled()) {
            logger.trace("Root element of input document is: " + className);
        }
        LLRPMessage message = null;
        if (className.equals("RO_ACCESS_REPORT")) {
            message = new RO_ACCESS_REPORT(document);
            return message;
        }
        if (className.equals("CUSTOM_MESSAGE")) {
            message = new CUSTOM_MESSAGE(document);
            return message;
        }
        if (className.equals("GET_READER_CAPABILITIES")) {
            message = new GET_READER_CAPABILITIES(document);
            return message;
        }
        if (className.equals("GET_READER_CAPABILITIES_RESPONSE")) {
            message = new GET_READER_CAPABILITIES_RESPONSE(document);
            return message;
        }
        if (className.equals("ADD_ROSPEC")) {
            message = new ADD_ROSPEC(document);
            return message;
        }
        if (className.equals("ADD_ROSPEC_RESPONSE")) {
            message = new ADD_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("DELETE_ROSPEC")) {
            message = new DELETE_ROSPEC(document);
            return message;
        }
        if (className.equals("DELETE_ROSPEC_RESPONSE")) {
            message = new DELETE_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("START_ROSPEC")) {
            message = new START_ROSPEC(document);
            return message;
        }
        if (className.equals("START_ROSPEC_RESPONSE")) {
            message = new START_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("STOP_ROSPEC")) {
            message = new STOP_ROSPEC(document);
            return message;
        }
        if (className.equals("STOP_ROSPEC_RESPONSE")) {
            message = new STOP_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("ENABLE_ROSPEC")) {
            message = new ENABLE_ROSPEC(document);
            return message;
        }
        if (className.equals("ENABLE_ROSPEC_RESPONSE")) {
            message = new ENABLE_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("DISABLE_ROSPEC")) {
            message = new DISABLE_ROSPEC(document);
            return message;
        }
        if (className.equals("DISABLE_ROSPEC_RESPONSE")) {
            message = new DISABLE_ROSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("GET_ROSPECS")) {
            message = new GET_ROSPECS(document);
            return message;
        }
        if (className.equals("GET_ROSPECS_RESPONSE")) {
            message = new GET_ROSPECS_RESPONSE(document);
            return message;
        }
        if (className.equals("ADD_ACCESSSPEC")) {
            message = new ADD_ACCESSSPEC(document);
            return message;
        }
        if (className.equals("ADD_ACCESSSPEC_RESPONSE")) {
            message = new ADD_ACCESSSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("DELETE_ACCESSSPEC")) {
            message = new DELETE_ACCESSSPEC(document);
            return message;
        }
        if (className.equals("DELETE_ACCESSSPEC_RESPONSE")) {
            message = new DELETE_ACCESSSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("ENABLE_ACCESSSPEC")) {
            message = new ENABLE_ACCESSSPEC(document);
            return message;
        }
        if (className.equals("ENABLE_ACCESSSPEC_RESPONSE")) {
            message = new ENABLE_ACCESSSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("DISABLE_ACCESSSPEC")) {
            message = new DISABLE_ACCESSSPEC(document);
            return message;
        }
        if (className.equals("DISABLE_ACCESSSPEC_RESPONSE")) {
            message = new DISABLE_ACCESSSPEC_RESPONSE(document);
            return message;
        }
        if (className.equals("GET_ACCESSSPECS")) {
            message = new GET_ACCESSSPECS(document);
            return message;
        }
        if (className.equals("GET_ACCESSSPECS_RESPONSE")) {
            message = new GET_ACCESSSPECS_RESPONSE(document);
            return message;
        }
        if (className.equals("CLIENT_REQUEST_OP")) {
            message = new CLIENT_REQUEST_OP(document);
            return message;
        }
        if (className.equals("CLIENT_REQUEST_OP_RESPONSE")) {
            message = new CLIENT_REQUEST_OP_RESPONSE(document);
            return message;
        }
        if (className.equals("GET_READER_CONFIG")) {
            message = new GET_READER_CONFIG(document);
            return message;
        }
        if (className.equals("GET_READER_CONFIG_RESPONSE")) {
            message = new GET_READER_CONFIG_RESPONSE(document);
            return message;
        }
        if (className.equals("SET_READER_CONFIG")) {
            message = new SET_READER_CONFIG(document);
            return message;
        }
        if (className.equals("SET_READER_CONFIG_RESPONSE")) {
            message = new SET_READER_CONFIG_RESPONSE(document);
            return message;
        }
        if (className.equals("CLOSE_CONNECTION")) {
            message = new CLOSE_CONNECTION(document);
            return message;
        }
        if (className.equals("CLOSE_CONNECTION_RESPONSE")) {
            message = new CLOSE_CONNECTION_RESPONSE(document);
            return message;
        }
        if (className.equals("GET_REPORT")) {
            message = new GET_REPORT(document);
            return message;
        }
        if (className.equals("RO_ACCESS_REPORT")) {
            message = new RO_ACCESS_REPORT(document);
            return message;
        }
        if (className.equals("KEEPALIVE")) {
            message = new KEEPALIVE(document);
            return message;
        }
        if (className.equals("KEEPALIVE_ACK")) {
            message = new KEEPALIVE_ACK(document);
            return message;
        }
        if (className.equals("READER_EVENT_NOTIFICATION")) {
            message = new READER_EVENT_NOTIFICATION(document);
            return message;
        }
        if (className.equals("ENABLE_EVENTS_AND_REPORTS")) {
            message = new ENABLE_EVENTS_AND_REPORTS(document);
            return message;
        }
        if (className.equals("ERROR_MESSAGE")) {
            message = new ERROR_MESSAGE(document);
            return message;
        }
        if (className.equals("IMPINJ_ENABLE_EXTENSIONS")) {
            message = new IMPINJ_ENABLE_EXTENSIONS(document);
        }
        if (className.equals("IMPINJ_ENABLE_EXTENSIONS_RESPONSE")) {
            message = new IMPINJ_ENABLE_EXTENSIONS_RESPONSE(document);
        }
        if (className.equals("IMPINJ_SAVE_SETTINGS")) {
            message = new IMPINJ_SAVE_SETTINGS(document);
        }
        if (className.equals("IMPINJ_SAVE_SETTINGS_RESPONSE")) {
            message = new IMPINJ_SAVE_SETTINGS_RESPONSE(document);
        }
        if (message == null) {
            throw new InvalidLLRPMessageException("The message type (\"" + className + "\") specified in the LTK-XML message is not known.");
        }
        return message;
    }
}

