/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionReportType;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionTagPopulationStatus;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionDiagnosticData;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedLong;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDirectionReportData
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1573);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDirectionReportData.class);
    protected ImpinjDirectionReportType type;
    protected ImpinjDirectionTagPopulationStatus tagPopulationStatus;
    protected UnsignedByte firstSeenSectorID;
    protected UnsignedLong firstSeenTimestampUTC;
    protected UnsignedByte lastSeenSectorID;
    protected UnsignedLong lastSeenTimestampUTC;
    private ImpinjDirectionDiagnosticData impinjDirectionDiagnosticData;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjDirectionReportData() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDirectionReportData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDirectionReportData(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1573);
        this.decodeXML(element);
    }

    public ImpinjDirectionReportData(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.type == null) {
            LOGGER.warn(" type not set");
        }
        resultBits.append(this.type.encodeBinary());
        if (this.tagPopulationStatus == null) {
            LOGGER.warn(" tagPopulationStatus not set");
        }
        resultBits.append(this.tagPopulationStatus.encodeBinary());
        if (this.firstSeenSectorID == null) {
            LOGGER.warn(" firstSeenSectorID not set");
        }
        resultBits.append(this.firstSeenSectorID.encodeBinary());
        if (this.firstSeenTimestampUTC == null) {
            LOGGER.warn(" firstSeenTimestampUTC not set");
        }
        resultBits.append(this.firstSeenTimestampUTC.encodeBinary());
        if (this.lastSeenSectorID == null) {
            LOGGER.warn(" lastSeenSectorID not set");
        }
        resultBits.append(this.lastSeenSectorID.encodeBinary());
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.warn(" lastSeenTimestampUTC not set");
        }
        resultBits.append(this.lastSeenTimestampUTC.encodeBinary());
        if (this.impinjDirectionDiagnosticData != null) {
            LOGGER.info(" impinjDirectionDiagnosticData not set");
            resultBits.append(this.impinjDirectionDiagnosticData.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        Element element = new Element(name, ns);
        if (this.type == null) {
            LOGGER.warn(" type not set");
            throw new MissingParameterException(" type not set");
        }
        element.addContent(this.type.encodeXML("Type", ns));
        if (this.tagPopulationStatus == null) {
            LOGGER.warn(" tagPopulationStatus not set");
            throw new MissingParameterException(" tagPopulationStatus not set");
        }
        element.addContent(this.tagPopulationStatus.encodeXML("TagPopulationStatus", ns));
        if (this.firstSeenSectorID == null) {
            LOGGER.warn(" firstSeenSectorID not set");
            throw new MissingParameterException(" firstSeenSectorID not set");
        }
        element.addContent(this.firstSeenSectorID.encodeXML("FirstSeenSectorID", ns));
        if (this.firstSeenTimestampUTC == null) {
            LOGGER.warn(" firstSeenTimestampUTC not set");
            throw new MissingParameterException(" firstSeenTimestampUTC not set");
        }
        element.addContent(this.firstSeenTimestampUTC.encodeXML("FirstSeenTimestampUTC", ns));
        if (this.lastSeenSectorID == null) {
            LOGGER.warn(" lastSeenSectorID not set");
            throw new MissingParameterException(" lastSeenSectorID not set");
        }
        element.addContent(this.lastSeenSectorID.encodeXML("LastSeenSectorID", ns));
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.warn(" lastSeenTimestampUTC not set");
            throw new MissingParameterException(" lastSeenTimestampUTC not set");
        }
        element.addContent(this.lastSeenTimestampUTC.encodeXML("LastSeenTimestampUTC", ns));
        if (this.impinjDirectionDiagnosticData == null) {
            LOGGER.info("impinjDirectionDiagnosticData not set");
        } else {
            element.addContent(this.impinjDirectionDiagnosticData.encodeXML(this.impinjDirectionDiagnosticData.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.type = new ImpinjDirectionReportType(binary.subList(position, ImpinjDirectionReportType.length()));
        this.tagPopulationStatus = new ImpinjDirectionTagPopulationStatus(binary.subList(position += ImpinjDirectionReportType.length(), ImpinjDirectionTagPopulationStatus.length()));
        this.firstSeenSectorID = new UnsignedByte(binary.subList(position += ImpinjDirectionTagPopulationStatus.length(), UnsignedByte.length()));
        this.firstSeenTimestampUTC = new UnsignedLong(binary.subList(position += UnsignedByte.length(), UnsignedLong.length()));
        this.lastSeenSectorID = new UnsignedByte(binary.subList(position += UnsignedLong.length(), UnsignedByte.length()));
        this.lastSeenTimestampUTC = new UnsignedLong(binary.subList(position += UnsignedByte.length(), UnsignedLong.length()));
        if ((position += UnsignedLong.length()) < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                UnsignedInteger subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDirectionDiagnosticData.VENDOR_ID) && subType.equals(ImpinjDirectionDiagnosticData.PARAMETER_SUBTYPE)) {
                    this.impinjDirectionDiagnosticData = new ImpinjDirectionDiagnosticData(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("Type", element.getNamespace());
        if (temp != null) {
            this.type = new ImpinjDirectionReportType(temp);
        }
        if ((temp = element.getChild("TagPopulationStatus", element.getNamespace())) != null) {
            this.tagPopulationStatus = new ImpinjDirectionTagPopulationStatus(temp);
        }
        if ((temp = element.getChild("FirstSeenSectorID", element.getNamespace())) != null) {
            this.firstSeenSectorID = new UnsignedByte(temp);
        }
        if ((temp = element.getChild("FirstSeenTimestampUTC", element.getNamespace())) != null) {
            this.firstSeenTimestampUTC = new UnsignedLong(temp);
        }
        if ((temp = element.getChild("LastSeenSectorID", element.getNamespace())) != null) {
            this.lastSeenSectorID = new UnsignedByte(temp);
        }
        if ((temp = element.getChild("LastSeenTimestampUTC", element.getNamespace())) != null) {
            this.lastSeenTimestampUTC = new UnsignedLong(temp);
        }
        if ((temp = element.getChild("ImpinjDirectionDiagnosticData", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionDiagnosticData", llrpns);
        }
        if (temp != null) {
            this.impinjDirectionDiagnosticData = new ImpinjDirectionDiagnosticData(temp);
            LOGGER.info("setting parameter impinjDirectionDiagnosticData for parameter ImpinjDirectionReportData");
        } else {
            LOGGER.info("ImpinjDirectionReportData misses non optional parameter of type impinjDirectionDiagnosticData");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjDirectionReportData misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setType(ImpinjDirectionReportType type) {
        this.type = type;
    }

    public void setTagPopulationStatus(ImpinjDirectionTagPopulationStatus tagPopulationStatus) {
        this.tagPopulationStatus = tagPopulationStatus;
    }

    public void setFirstSeenSectorID(UnsignedByte firstSeenSectorID) {
        this.firstSeenSectorID = firstSeenSectorID;
    }

    public void setFirstSeenTimestampUTC(UnsignedLong firstSeenTimestampUTC) {
        this.firstSeenTimestampUTC = firstSeenTimestampUTC;
    }

    public void setLastSeenSectorID(UnsignedByte lastSeenSectorID) {
        this.lastSeenSectorID = lastSeenSectorID;
    }

    public void setLastSeenTimestampUTC(UnsignedLong lastSeenTimestampUTC) {
        this.lastSeenTimestampUTC = lastSeenTimestampUTC;
    }

    public void setImpinjDirectionDiagnosticData(ImpinjDirectionDiagnosticData impinjDirectionDiagnosticData) {
        this.impinjDirectionDiagnosticData = impinjDirectionDiagnosticData;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjDirectionReportType getType() {
        return this.type;
    }

    public ImpinjDirectionTagPopulationStatus getTagPopulationStatus() {
        return this.tagPopulationStatus;
    }

    public UnsignedByte getFirstSeenSectorID() {
        return this.firstSeenSectorID;
    }

    public UnsignedLong getFirstSeenTimestampUTC() {
        return this.firstSeenTimestampUTC;
    }

    public UnsignedByte getLastSeenSectorID() {
        return this.lastSeenSectorID;
    }

    public UnsignedLong getLastSeenTimestampUTC() {
        return this.lastSeenTimestampUTC;
    }

    public ImpinjDirectionDiagnosticData getImpinjDirectionDiagnosticData() {
        return this.impinjDirectionDiagnosticData;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

