/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2TagInventoryMask
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(332);
    private static final Logger LOGGER = Logger.getLogger(C1G2TagInventoryMask.class);
    protected TwoBitField mB;
    protected BitList reserved0 = new BitList(6);
    protected UnsignedShort pointer;
    protected BitArray_HEX tagMask;

    public C1G2TagInventoryMask() {
    }

    public C1G2TagInventoryMask(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2TagInventoryMask(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public C1G2TagInventoryMask(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.mB == null) {
            LOGGER.warn(" mB not set");
            throw new MissingParameterException(" mB not set  for Parameter of Type C1G2TagInventoryMask");
        }
        resultBits.append(this.mB.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.pointer == null) {
            LOGGER.warn(" pointer not set");
            throw new MissingParameterException(" pointer not set  for Parameter of Type C1G2TagInventoryMask");
        }
        resultBits.append(this.pointer.encodeBinary());
        if (this.tagMask == null) {
            LOGGER.warn(" tagMask not set");
            throw new MissingParameterException(" tagMask not set  for Parameter of Type C1G2TagInventoryMask");
        }
        resultBits.append(this.tagMask.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.mB == null) {
            LOGGER.warn(" mB not set");
            throw new MissingParameterException(" mB not set");
        }
        element.addContent(this.mB.encodeXML("MB", ns));
        if (this.pointer == null) {
            LOGGER.warn(" pointer not set");
            throw new MissingParameterException(" pointer not set");
        }
        element.addContent(this.pointer.encodeXML("Pointer", ns));
        if (this.tagMask == null) {
            LOGGER.warn(" tagMask not set");
            throw new MissingParameterException(" tagMask not set");
        }
        element.addContent(this.tagMask.encodeXML("TagMask", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.mB = new TwoBitField(binary, position, TwoBitField.length());
        position += TwoBitField.length();
        this.pointer = new UnsignedShort(binary, position += this.reserved0.length(), UnsignedShort.length());
        short fieldCount = new SignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length()).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        if (tempLength % 8 > 0) {
            tempLength += 8 - tempLength % 8;
            LOGGER.info("padding needed for tagMask ");
        }
        this.tagMask = new BitArray_HEX(binary, position, tempLength);
        position += tempLength;
        LOGGER.trace("decoding array of type: BitArray_HEX with " + tempLength + " length");
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("MB", ns);
        if (temp != null) {
            this.mB = new TwoBitField(temp);
        }
        element.removeChild("MB", ns);
        temp = element.getChild("Pointer", ns);
        if (temp != null) {
            this.pointer = new UnsignedShort(temp);
        }
        element.removeChild("Pointer", ns);
        temp = element.getChild("TagMask", ns);
        if (temp != null) {
            this.tagMask = new BitArray_HEX(temp);
        }
        element.removeChild("TagMask", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2TagInventoryMask has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setMB(TwoBitField mB) {
        this.mB = mB;
    }

    public void setPointer(UnsignedShort pointer) {
        this.pointer = pointer;
    }

    public void setTagMask(BitArray_HEX tagMask) {
        this.tagMask = tagMask;
    }

    public TwoBitField getMB() {
        return this.mB;
    }

    public UnsignedShort getPointer() {
        return this.pointer;
    }

    public BitArray_HEX getTagMask() {
        return this.tagMask;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2TagInventoryMask";
    }

    public String toString() {
        String result = "C1G2TagInventoryMask: ";
        result = result + ", mB: ";
        result = result + this.mB;
        result = result + ", pointer: ";
        result = result + this.pointer;
        result = result + ", tagMask: ";
        result = result + this.tagMask;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

