/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class ClientRequestOpSpec
extends TLVParameter
implements AccessCommandOpSpec {
    public static final SignedShort TYPENUM = new SignedShort(210);
    private static final Logger LOGGER = Logger.getLogger(ClientRequestOpSpec.class);
    protected UnsignedShort opSpecID;

    public ClientRequestOpSpec() {
    }

    public ClientRequestOpSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ClientRequestOpSpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ClientRequestOpSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set  for Parameter of Type ClientRequestOpSpec");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.opSpecID = new UnsignedShort(binary, position, UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        element.removeChild("OpSpecID", ns);
        if (element.getChildren().size() > 0) {
            String message = "ClientRequestOpSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ClientRequestOpSpec";
    }

    public String toString() {
        String result = "ClientRequestOpSpec: ";
        result = result + ", opSpecID: ";
        result = result + this.opSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

