/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjHubConfiguration;
import org.llrp.ltk.generated.parameters.AccessSpecID;
import org.llrp.ltk.generated.parameters.AntennaID;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.InventoryParameterSpecID;
import org.llrp.ltk.generated.parameters.OpSpecID;
import org.llrp.ltk.generated.parameters.ROSpecID;
import org.llrp.ltk.generated.parameters.SpecIndex;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UTF8String_UTF_8;
import org.llrp.ltk.types.UnsignedShort;

public class ReaderExceptionEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(252);
    private static final Logger LOGGER = Logger.getLogger(ReaderExceptionEvent.class);
    protected UTF8String_UTF_8 message;
    protected ROSpecID rOSpecID;
    protected SpecIndex specIndex;
    protected InventoryParameterSpecID inventoryParameterSpecID;
    protected AntennaID antennaID;
    protected AccessSpecID accessSpecID;
    protected OpSpecID opSpecID;
    protected List<Custom> customList = new LinkedList<Custom>();

    public ReaderExceptionEvent() {
    }

    public ReaderExceptionEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ReaderExceptionEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ReaderExceptionEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.message == null) {
            LOGGER.warn(" message not set");
            throw new MissingParameterException(" message not set  for Parameter of Type ReaderExceptionEvent");
        }
        resultBits.append(this.message.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.info(" rOSpecID not set");
        } else {
            resultBits.append(this.rOSpecID.encodeBinary());
        }
        if (this.specIndex == null) {
            LOGGER.info(" specIndex not set");
        } else {
            resultBits.append(this.specIndex.encodeBinary());
        }
        if (this.inventoryParameterSpecID == null) {
            LOGGER.info(" inventoryParameterSpecID not set");
        } else {
            resultBits.append(this.inventoryParameterSpecID.encodeBinary());
        }
        if (this.antennaID == null) {
            LOGGER.info(" antennaID not set");
        } else {
            resultBits.append(this.antennaID.encodeBinary());
        }
        if (this.accessSpecID == null) {
            LOGGER.info(" accessSpecID not set");
        } else {
            resultBits.append(this.accessSpecID.encodeBinary());
        }
        if (this.opSpecID == null) {
            LOGGER.info(" opSpecID not set");
        } else {
            resultBits.append(this.opSpecID.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.message == null) {
            LOGGER.warn(" message not set");
            throw new MissingParameterException(" message not set");
        }
        element.addContent(this.message.encodeXML("Message", ns));
        if (this.rOSpecID == null) {
            LOGGER.info("rOSpecID not set");
        } else {
            element.addContent(this.rOSpecID.encodeXML(this.rOSpecID.getClass().getSimpleName(), ns));
        }
        if (this.specIndex == null) {
            LOGGER.info("specIndex not set");
        } else {
            element.addContent(this.specIndex.encodeXML(this.specIndex.getClass().getSimpleName(), ns));
        }
        if (this.inventoryParameterSpecID == null) {
            LOGGER.info("inventoryParameterSpecID not set");
        } else {
            element.addContent(this.inventoryParameterSpecID.encodeXML(this.inventoryParameterSpecID.getClass().getSimpleName(), ns));
        }
        if (this.antennaID == null) {
            LOGGER.info("antennaID not set");
        } else {
            element.addContent(this.antennaID.encodeXML(this.antennaID.getClass().getSimpleName(), ns));
        }
        if (this.accessSpecID == null) {
            LOGGER.info("accessSpecID not set");
        } else {
            element.addContent(this.accessSpecID.encodeXML(this.accessSpecID.getClass().getSimpleName(), ns));
        }
        if (this.opSpecID == null) {
            LOGGER.info("opSpecID not set");
        } else {
            element.addContent(this.opSpecID.encodeXML(this.opSpecID.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        short fieldCount = new SignedShort(binary, position, UnsignedShort.length()).toShort();
        tempLength = UTF8String_UTF_8.length() * fieldCount + UnsignedShort.length();
        if (tempLength % 8 > 0) {
            tempLength += 8 - tempLength % 8;
            LOGGER.info("padding needed for message ");
        }
        this.message = new UTF8String_UTF_8(binary, position, tempLength);
        position += tempLength;
        LOGGER.trace("decoding array of type: UTF8String_UTF_8 with " + tempLength + " length");
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type ROSpecID");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.rOSpecID.length();
        }
        if (type != null && type.equals(ROSpecID.TYPENUM)) {
            this.rOSpecID = new ROSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" rOSpecID is instantiated with ROSpecID with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type ROSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type SpecIndex");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.specIndex.length();
        }
        if (type != null && type.equals(SpecIndex.TYPENUM)) {
            this.specIndex = new SpecIndex(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" specIndex is instantiated with SpecIndex with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type SpecIndex");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type InventoryParameterSpecID");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.inventoryParameterSpecID.length();
        }
        if (type != null && type.equals(InventoryParameterSpecID.TYPENUM)) {
            this.inventoryParameterSpecID = new InventoryParameterSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" inventoryParameterSpecID is instantiated with InventoryParameterSpecID with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type InventoryParameterSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type AntennaID");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.antennaID.length();
        }
        if (type != null && type.equals(AntennaID.TYPENUM)) {
            this.antennaID = new AntennaID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" antennaID is instantiated with AntennaID with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type AntennaID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type AccessSpecID");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.accessSpecID.length();
        }
        if (type != null && type.equals(AccessSpecID.TYPENUM)) {
            this.accessSpecID = new AccessSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" accessSpecID is instantiated with AccessSpecID with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type AccessSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type OpSpecID");
        }
        if (binary.get(position)) {
            ReaderExceptionEvent readerExceptionEvent = this;
            tempLength = readerExceptionEvent.opSpecID.length();
        }
        if (type != null && type.equals(OpSpecID.TYPENUM)) {
            this.opSpecID = new OpSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" opSpecID is instantiated with OpSpecID with length" + tempLength);
        } else {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type OpSpecID");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjHubConfiguration.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjHubConfiguration(cus));
                    LOGGER.trace("adding ImpinjHubConfiguration to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Message", ns);
        if (temp != null) {
            this.message = new UTF8String_UTF_8(temp);
        }
        element.removeChild("Message", ns);
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new ROSpecID(temp);
            LOGGER.info("setting parameter rOSpecID for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type rOSpecID");
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new SpecIndex(temp);
            LOGGER.info("setting parameter specIndex for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type specIndex");
        }
        element.removeChild("SpecIndex", ns);
        temp = element.getChild("InventoryParameterSpecID", ns);
        if (temp != null) {
            this.inventoryParameterSpecID = new InventoryParameterSpecID(temp);
            LOGGER.info("setting parameter inventoryParameterSpecID for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type inventoryParameterSpecID");
        }
        element.removeChild("InventoryParameterSpecID", ns);
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new AntennaID(temp);
            LOGGER.info("setting parameter antennaID for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type antennaID");
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("AccessSpecID", ns);
        if (temp != null) {
            this.accessSpecID = new AccessSpecID(temp);
            LOGGER.info("setting parameter accessSpecID for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type accessSpecID");
        }
        element.removeChild("AccessSpecID", ns);
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new OpSpecID(temp);
            LOGGER.info("setting parameter opSpecID for parameter ReaderExceptionEvent");
        }
        if (temp == null) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type opSpecID");
        }
        element.removeChild("OpSpecID", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace("ReaderExceptionEvent misses optional parameter of type customList");
        } else {
            for (Iterator e : tempList) {
                this.customList.add(new Custom((Element)((Object)e)));
                LOGGER.trace("adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        Namespace nsImpinjHubConfiguration = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjHubConfiguration", nsImpinjHubConfiguration);
        for (Element e : tempList) {
            this.customList.add(new ImpinjHubConfiguration(e));
            LOGGER.trace("adding ImpinjHubConfiguration to customList ");
        }
        element.removeChildren("ImpinjHubConfiguration", nsImpinjHubConfiguration);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace("adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "ReaderExceptionEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setMessage(UTF8String_UTF_8 message) {
        this.message = message;
    }

    public void setROSpecID(ROSpecID rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setSpecIndex(SpecIndex specIndex) {
        this.specIndex = specIndex;
    }

    public void setInventoryParameterSpecID(InventoryParameterSpecID inventoryParameterSpecID) {
        this.inventoryParameterSpecID = inventoryParameterSpecID;
    }

    public void setAntennaID(AntennaID antennaID) {
        this.antennaID = antennaID;
    }

    public void setAccessSpecID(AccessSpecID accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public void setOpSpecID(OpSpecID opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UTF8String_UTF_8 getMessage() {
        return this.message;
    }

    public ROSpecID getROSpecID() {
        return this.rOSpecID;
    }

    public SpecIndex getSpecIndex() {
        return this.specIndex;
    }

    public InventoryParameterSpecID getInventoryParameterSpecID() {
        return this.inventoryParameterSpecID;
    }

    public AntennaID getAntennaID() {
        return this.antennaID;
    }

    public AccessSpecID getAccessSpecID() {
        return this.accessSpecID;
    }

    public OpSpecID getOpSpecID() {
        return this.opSpecID;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ReaderExceptionEvent";
    }

    public String toString() {
        String result = "ReaderExceptionEvent: ";
        result = result + ", message: ";
        result = result + this.message;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

