/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.TagObservationTriggerType;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class TagObservationTrigger
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(185);
    private static final Logger LOGGER = Logger.getLogger(TagObservationTrigger.class);
    protected TagObservationTriggerType triggerType;
    protected BitList reserved0 = new BitList(8);
    protected UnsignedShort numberOfTags;
    protected UnsignedShort numberOfAttempts;
    protected UnsignedShort t;
    protected UnsignedInteger timeout;

    public TagObservationTrigger() {
    }

    public TagObservationTrigger(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public TagObservationTrigger(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public TagObservationTrigger(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.triggerType == null) {
            LOGGER.warn(" triggerType not set");
            throw new MissingParameterException(" triggerType not set  for Parameter of Type TagObservationTrigger");
        }
        resultBits.append(this.triggerType.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.numberOfTags == null) {
            LOGGER.warn(" numberOfTags not set");
            throw new MissingParameterException(" numberOfTags not set  for Parameter of Type TagObservationTrigger");
        }
        resultBits.append(this.numberOfTags.encodeBinary());
        if (this.numberOfAttempts == null) {
            LOGGER.warn(" numberOfAttempts not set");
            throw new MissingParameterException(" numberOfAttempts not set  for Parameter of Type TagObservationTrigger");
        }
        resultBits.append(this.numberOfAttempts.encodeBinary());
        if (this.t == null) {
            LOGGER.warn(" t not set");
            throw new MissingParameterException(" t not set  for Parameter of Type TagObservationTrigger");
        }
        resultBits.append(this.t.encodeBinary());
        if (this.timeout == null) {
            LOGGER.warn(" timeout not set");
            throw new MissingParameterException(" timeout not set  for Parameter of Type TagObservationTrigger");
        }
        resultBits.append(this.timeout.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.triggerType == null) {
            LOGGER.warn(" triggerType not set");
            throw new MissingParameterException(" triggerType not set");
        }
        element.addContent(this.triggerType.encodeXML("TriggerType", ns));
        if (this.numberOfTags == null) {
            LOGGER.warn(" numberOfTags not set");
            throw new MissingParameterException(" numberOfTags not set");
        }
        element.addContent(this.numberOfTags.encodeXML("NumberOfTags", ns));
        if (this.numberOfAttempts == null) {
            LOGGER.warn(" numberOfAttempts not set");
            throw new MissingParameterException(" numberOfAttempts not set");
        }
        element.addContent(this.numberOfAttempts.encodeXML("NumberOfAttempts", ns));
        if (this.t == null) {
            LOGGER.warn(" t not set");
            throw new MissingParameterException(" t not set");
        }
        element.addContent(this.t.encodeXML("T", ns));
        if (this.timeout == null) {
            LOGGER.warn(" timeout not set");
            throw new MissingParameterException(" timeout not set");
        }
        element.addContent(this.timeout.encodeXML("Timeout", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.triggerType = new TagObservationTriggerType(binary, position, TagObservationTriggerType.length());
        position += TagObservationTriggerType.length();
        this.numberOfTags = new UnsignedShort(binary, position += this.reserved0.length(), UnsignedShort.length());
        this.numberOfAttempts = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        this.t = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        this.timeout = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("TriggerType", ns);
        if (temp != null) {
            this.triggerType = new TagObservationTriggerType(temp);
        }
        element.removeChild("TriggerType", ns);
        temp = element.getChild("NumberOfTags", ns);
        if (temp != null) {
            this.numberOfTags = new UnsignedShort(temp);
        }
        element.removeChild("NumberOfTags", ns);
        temp = element.getChild("NumberOfAttempts", ns);
        if (temp != null) {
            this.numberOfAttempts = new UnsignedShort(temp);
        }
        element.removeChild("NumberOfAttempts", ns);
        temp = element.getChild("T", ns);
        if (temp != null) {
            this.t = new UnsignedShort(temp);
        }
        element.removeChild("T", ns);
        temp = element.getChild("Timeout", ns);
        if (temp != null) {
            this.timeout = new UnsignedInteger(temp);
        }
        element.removeChild("Timeout", ns);
        if (element.getChildren().size() > 0) {
            String message = "TagObservationTrigger has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setTriggerType(TagObservationTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setNumberOfTags(UnsignedShort numberOfTags) {
        this.numberOfTags = numberOfTags;
    }

    public void setNumberOfAttempts(UnsignedShort numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
    }

    public void setT(UnsignedShort t) {
        this.t = t;
    }

    public void setTimeout(UnsignedInteger timeout) {
        this.timeout = timeout;
    }

    public TagObservationTriggerType getTriggerType() {
        return this.triggerType;
    }

    public UnsignedShort getNumberOfTags() {
        return this.numberOfTags;
    }

    public UnsignedShort getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public UnsignedShort getT() {
        return this.t;
    }

    public UnsignedInteger getTimeout() {
        return this.timeout;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "TagObservationTrigger";
    }

    public String toString() {
        String result = "TagObservationTrigger: ";
        result = result + ", triggerType: ";
        result = result + this.triggerType;
        result = result + ", numberOfTags: ";
        result = result + this.numberOfTags;
        result = result + ", numberOfAttempts: ";
        result = result + this.numberOfAttempts;
        result = result + ", t: ";
        result = result + this.t;
        result = result + ", timeout: ";
        result = result + this.timeout;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

