/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.LinkedList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedShort;

public class BitArray_HEX
extends BitArray {
    protected int validBits;

    public BitArray_HEX(Bit[] bits) {
        super(bits);
        this.validBits = bits.length;
    }

    public BitArray_HEX(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public BitArray_HEX(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public BitArray_HEX(int length) {
        super(length);
        this.validBits = this.bits.length;
    }

    public BitArray_HEX() {
        this.validBits = this.bits.length;
    }

    public BitArray_HEX(Element element) {
        this.decodeXML(element);
    }

    public BitArray_HEX(String hexString) {
        Element element = new Element("foo", "ns");
        element.setText(hexString);
        this.decodeXML(element);
    }

    public static int length() {
        return 1;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        String bitString = "";
        for (int i = 0; i < this.bits.length; ++i) {
            bitString = bitString + this.bits[i];
        }
        int totalBits = 0;
        int mod = this.validBits % 8;
        if (this.validBits > 0 && mod > 0) {
            totalBits = this.validBits + (8 - mod);
        }
        totalBits -= this.bits.length;
        element.setAttribute("Count", new Integer(this.validBits).toString());
        if (mod != 0) {
            for (int a = 0; a < totalBits; ++a) {
                bitString = bitString + "0";
            }
        }
        String result = "";
        for (int i = 0; i < bitString.length(); i += 4) {
            result = result + Integer.toHexString(Integer.parseInt(bitString.substring(i, i + 4), 2)).toUpperCase();
        }
        element.setContent(new Text(result));
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String hexString = element.getText().trim();
        String countString = element.getAttributeValue("Count");
        this.validBits = countString != null ? Integer.parseInt(countString.trim()) : hexString.length() * 4;
        LinkedList<Bit> tempList = new LinkedList<Bit>();
        int length = hexString.length();
        for (int a = 0; a < length; ++a) {
            int j;
            char hexDigit = hexString.charAt(a);
            Integer hexInt = Integer.parseInt(hexDigit + "", 16);
            String bitString = Integer.toBinaryString(hexInt);
            String padding = "";
            for (j = 0; j < 4 - bitString.length(); ++j) {
                padding = padding + "0";
            }
            bitString = padding + bitString;
            for (j = 0; j < bitString.length(); ++j) {
                tempList.add(new Bit(bitString.charAt(j) + ""));
            }
        }
        Bit[] bs = new Bit[tempList.size()];
        this.bits = tempList.toArray(bs);
    }

    @Override
    public LLRPBitList encodeBinary() {
        int mod;
        LLRPBitList padding = null;
        int totalBits = 0;
        if (this.validBits > 0 && (mod = this.validBits % 8) > 0) {
            totalBits = this.validBits + (8 - mod);
        }
        padding = (totalBits -= this.bits.length) > 0 ? new LLRPBitList(totalBits) : new LLRPBitList();
        LLRPBitList result = new UnsignedShort(this.validBits).encodeBinary();
        for (int i = 0; i < this.bits.length; ++i) {
            result.add(this.bits[i].toBoolean());
        }
        result.append(padding);
        return result;
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        this.validBits = new SignedInteger(list, 0, SignedShort.length()).toInteger();
        int length = list.length() - SignedShort.length();
        this.bits = new Bit[length];
        Integer i = 1;
        while (i <= length) {
            this.bits[i.intValue() - 1] = new Bit(list.get(15 + i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Override
    public String toString() {
        return this.encodeXML("foo", Namespace.getNamespace("foo")).getValue();
    }
}

