/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.util;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.util.Util;

public class LLRPConverter {
    static final Logger LOGGER = Logger.getLogger("LLRPConverter.class");
    static final byte[] errFrame = new byte[]{4, 100, 0, 0, 0, 18, 0, 0, 0, 0, 1, 31, 0, 8, 0, 0, 0, 0};
    static final String errString = "<ERROR_MESSAGE MessageID=\"0\" Version=\"0\">\n  <LLRPStatus>\n    <StatusCode>M_Success</StatusCode>\n    <ErrorDescription></ErrorDescription>\n  </LLRPStatus>\n</ERROR_MESSAGE>\n";

    private void convertFilesInDirectory(String dir, String target, Boolean xml) {
        File testDir = new File(dir);
        String targetDir = target == null ? dir : target;
        FilenameFilter filter = xml == Boolean.FALSE ? new BinaryFilter() : new XMLFilter();
        String[] filenames = testDir.list(filter);
        for (int i = 0; filenames != null && i < filenames.length; ++i) {
            LLRPMessage message;
            String filename = filenames[i];
            int dotPos = filename.lastIndexOf(".");
            if (xml == Boolean.TRUE) {
                byte[] data = null;
                try {
                    message = Util.loadXMLLLRPMessage(new File(dir + "/" + filename));
                    data = message.encodeBinary();
                }
                catch (FileNotFoundException ex) {
                    continue;
                }
                catch (IOException ex) {
                    System.out.println("Error reading input file: " + filename);
                    data = errFrame;
                }
                catch (InvalidLLRPMessageException ex) {
                    System.out.println("Error converting file LLRP Message: " + filename);
                    data = errFrame;
                }
                catch (JDOMException ex) {
                    System.out.println("Error reading LTK-XML to DOM from: " + filename);
                    data = errFrame;
                }
                filename = filename.substring(0, dotPos) + ".bin";
                try {
                    FileOutputStream ous = new FileOutputStream(new File(targetDir + "/" + filename));
                    ous.write(data);
                    ous.flush();
                    ous.close();
                    System.out.println("Successfully converted to " + filename);
                }
                catch (FileNotFoundException ex) {
                    System.out.println("Unable to write output file " + filename);
                    System.exit(-1);
                }
                catch (IOException ex) {
                    System.out.println("Unable to write output file " + filename);
                    System.exit(-2);
                }
                continue;
            }
            String xmlMsg = null;
            try {
                message = Util.loadBinaryLLRPMessage(new File(dir + "/" + filename));
                xmlMsg = message.toXMLString();
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (IOException ex) {
                System.out.println("Error reading input file: " + filename);
                xmlMsg = errString;
            }
            catch (InvalidLLRPMessageException ex) {
                System.out.println("Error converting file LLRP Message: " + filename);
                xmlMsg = errString;
            }
            filename = filename.substring(0, dotPos) + ".xml";
            try {
                FileWriter out = new FileWriter(new File(targetDir + "/" + filename));
                out.write(xmlMsg);
                out.close();
                System.out.println("Successfully converted to " + filename);
                continue;
            }
            catch (FileNotFoundException ex) {
                System.out.println("Unable to write output file " + filename);
                System.exit(-1);
                continue;
            }
            catch (IOException ex) {
                System.out.println("Unable to write output file " + filename);
                System.exit(-2);
            }
        }
    }

    private void convert(Boolean xml, Boolean binary, String file, String dir, String targetDir) {
        try {
            if (binary != null) {
                if (file != null) {
                    LLRPMessage message = Util.loadBinaryLLRPMessage(new File(file));
                    System.out.println(message.toXMLString());
                } else if (dir != null) {
                    this.convertFilesInDirectory(dir, targetDir, Boolean.FALSE);
                } else {
                    System.err.println("This should never happen!");
                }
            } else if (xml != null) {
                if (file != null) {
                    LLRPMessage message = Util.loadXMLLLRPMessage(new File(file));
                    System.out.println(message.toHexString());
                } else if (dir != null) {
                    this.convertFilesInDirectory(dir, targetDir, Boolean.TRUE);
                } else {
                    System.err.println("This should never happen!");
                }
            }
        }
        catch (InvalidLLRPMessageException e) {
            System.err.println("LLRP Message is not valid " + file);
            System.err.println(e.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("File not found");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        catch (JDOMException e) {
            System.err.println("Invalid XML document to instantiate LLRP Message" + file);
            System.exit(2);
        }
    }

    private static void printUsage() {
        System.err.println("Usage: java -jar LTKJava<Version>.jar  [{-v,--verbose}]\n                      [{-b,--binary}] input message(s) is in LLRP binary format\n                      [{-x,--xml}] input message(s) is in LTK XML format\n                      [{-d,--dir} directory path] directory with messages\n                      [{-f,--file} file path] file to be converted\n                      [{-o,--output} file path] send output to specific \n                      [{-t,--targetDir} targetDirectory path] target directory for converted messages\n\nExample binary->xml file conversion to console:\n java -jar LTKJava<Version>.jar -b -f ADD_ROSPEC.bin\nExample xml->binary file conversion to console:\n java -jar LTKJava<Version>.jar -x -f ADD_ROSPEC.xml\nExample xml->binary file conversion of all files in a dir:\n       java -jar LTKJava<Version>.jar -x -d messages/xml -t messages/bin\n");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.ERROR);
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verbose = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option binary = parser.addBooleanOption('b', "binary");
        CmdLineParser.Option xml = parser.addBooleanOption('x', "xml");
        CmdLineParser.Option dir = parser.addStringOption('d', "dir");
        CmdLineParser.Option file = parser.addStringOption('f', "file");
        CmdLineParser.Option targetDir = parser.addStringOption('t', "targetDir");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            LLRPConverter.printUsage();
            System.exit(2);
        }
        Boolean verboseValue = (Boolean)parser.getOptionValue(verbose, Boolean.FALSE);
        Boolean xmlValue = (Boolean)parser.getOptionValue(xml);
        Boolean binaryValue = (Boolean)parser.getOptionValue(binary);
        String dirValue = (String)parser.getOptionValue(dir);
        String fileValue = (String)parser.getOptionValue(file);
        String targetDirValue = (String)parser.getOptionValue(targetDir);
        if (verboseValue.booleanValue()) {
            rootLogger.setLevel(Level.ALL);
        }
        if (xmlValue == null && binaryValue == null && fileValue == null && dirValue == null) {
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (xmlValue == null && binaryValue == null) {
            System.err.println("Specify the type of input message format (either binary or xml)");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (xmlValue != null && binaryValue != null) {
            System.err.println("Specify the type of input message format (either binary or xml)");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (fileValue == null && dirValue == null) {
            System.err.println("Specify a file or directory for conversion");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (fileValue != null && dirValue != null) {
            System.err.println("Specify either a file or a directory for conversion");
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (targetDirValue != null && !new File(targetDirValue).isDirectory()) {
            System.err.println("Target Directory does not exist: " + targetDirValue);
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (dirValue != null && !new File(dirValue).isDirectory()) {
            System.err.println("Directory does not exist: " + dirValue);
            LLRPConverter.printUsage();
            System.exit(2);
        }
        if (fileValue != null && !new File(fileValue).isFile()) {
            System.err.println("File does not exist: " + fileValue);
            LLRPConverter.printUsage();
            System.exit(2);
        }
        LLRPConverter converter = new LLRPConverter();
        converter.convert(xmlValue, binaryValue, fileValue, dirValue, targetDirValue);
    }

    class XMLFilter
    implements FilenameFilter {
        XMLFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }

    class BinaryFilter
    implements FilenameFilter {
        BinaryFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".bin");
        }
    }
}

