/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedShort;

public class BitArray
extends LLRPType {
    protected static final int LENGTH = 1;
    protected Bit[] bits;

    public BitArray(Bit[] bits) {
        this.bits = (Bit[])bits.clone();
    }

    public BitArray(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public BitArray(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public BitArray(int length) {
        this.bits = new Bit[length];
        for (int i = 0; i < length; ++i) {
            this.bits[i] = new Bit(false);
        }
    }

    public BitArray() {
        this.bits = new Bit[0];
    }

    public BitArray(Element element) {
        this.decodeXML(element);
    }

    public BitArray(String binaryString) {
        Element element = new Element("foo", "ns");
        element.setText(binaryString);
        this.decodeXML(element);
    }

    public void clear(int i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i] = new Bit(false);
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList padding = null;
        padding = this.bits.length % 8 > 0 ? new LLRPBitList(8 - this.bits.length % 8) : new LLRPBitList();
        int len = this.bits.length + padding.length() / 8;
        LLRPBitList result = new UnsignedShort(len).encodeBinary();
        for (int i = 0; i < this.bits.length; ++i) {
            result.add(this.bits[i].toBoolean());
        }
        result.append(padding);
        return result;
    }

    public static int length() {
        return Bit.length();
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        Integer length = new SignedInteger(list.subList(0, SignedShort.length())).toInteger();
        this.bits = new Bit[length.intValue()];
        Integer i = 1;
        while (i <= length) {
            this.bits[i.intValue() - 1] = new Bit(list.get(15 + i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public Bit get(int i) {
        return this.bits[i];
    }

    public void set(int i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i] = new Bit(true);
    }

    public int size() {
        return this.bits.length;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setText(this.toString());
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String text = element.getText().trim();
        if (!text.equals("")) {
            String[] bitStrings = text.split("\\s+");
            this.bits = new Bit[bitStrings.length];
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = new Bit(bitStrings[i]);
            }
        } else {
            this.bits = new Bit[0];
        }
    }

    public void add(Bit aBit) {
        Bit[] newBits = new Bit[this.bits.length + 1];
        System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
        newBits[this.bits.length] = aBit;
        this.bits = newBits;
    }

    @Override
    public String toString() {
        String s = "";
        for (Bit b : this.bits) {
            s = s + b.toInteger().toString();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    @Override
    public String toString(int radix) {
        String s = "";
        for (Bit b : this.bits) {
            s = s + Integer.toString(b.toInteger(), radix);
        }
        return s;
    }

    @Override
    public boolean inRange(String valueString) {
        String[] strings = valueString.split("\\s+");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new Bit(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

