/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.AntennaEventType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class AntennaEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(255);
    private static final Logger LOGGER = Logger.getLogger(AntennaEvent.class);
    protected AntennaEventType eventType;
    protected UnsignedShort antennaID;

    public AntennaEvent() {
    }

    public AntennaEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AntennaEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AntennaEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventType == null) {
            LOGGER.warn(" eventType not set");
            throw new MissingParameterException(" eventType not set  for Parameter of Type AntennaEvent");
        }
        resultBits.append(this.eventType.encodeBinary());
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type AntennaEvent");
        }
        resultBits.append(this.antennaID.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.eventType == null) {
            LOGGER.warn(" eventType not set");
            throw new MissingParameterException(" eventType not set");
        }
        element.addContent(this.eventType.encodeXML("EventType", ns));
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.eventType = new AntennaEventType(binary, position, AntennaEventType.length());
        this.antennaID = new UnsignedShort(binary, position += AntennaEventType.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EventType", ns);
        if (temp != null) {
            this.eventType = new AntennaEventType(temp);
        }
        element.removeChild("EventType", ns);
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        if (element.getChildren().size() > 0) {
            String message = "AntennaEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventType(AntennaEventType eventType) {
        this.eventType = eventType;
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public AntennaEventType getEventType() {
        return this.eventType;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AntennaEvent";
    }

    public String toString() {
        String result = "AntennaEvent: ";
        result = result + ", eventType: ";
        result = result + this.eventType;
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

