/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class GPIOCapabilities
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(141);
    private static final Logger LOGGER = Logger.getLogger(GPIOCapabilities.class);
    protected UnsignedShort numGPIs;
    protected UnsignedShort numGPOs;

    public GPIOCapabilities() {
    }

    public GPIOCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GPIOCapabilities(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public GPIOCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.numGPIs == null) {
            LOGGER.warn(" numGPIs not set");
            throw new MissingParameterException(" numGPIs not set  for Parameter of Type GPIOCapabilities");
        }
        resultBits.append(this.numGPIs.encodeBinary());
        if (this.numGPOs == null) {
            LOGGER.warn(" numGPOs not set");
            throw new MissingParameterException(" numGPOs not set  for Parameter of Type GPIOCapabilities");
        }
        resultBits.append(this.numGPOs.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.numGPIs == null) {
            LOGGER.warn(" numGPIs not set");
            throw new MissingParameterException(" numGPIs not set");
        }
        element.addContent(this.numGPIs.encodeXML("NumGPIs", ns));
        if (this.numGPOs == null) {
            LOGGER.warn(" numGPOs not set");
            throw new MissingParameterException(" numGPOs not set");
        }
        element.addContent(this.numGPOs.encodeXML("NumGPOs", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.numGPIs = new UnsignedShort(binary, position, UnsignedShort.length());
        this.numGPOs = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("NumGPIs", ns);
        if (temp != null) {
            this.numGPIs = new UnsignedShort(temp);
        }
        element.removeChild("NumGPIs", ns);
        temp = element.getChild("NumGPOs", ns);
        if (temp != null) {
            this.numGPOs = new UnsignedShort(temp);
        }
        element.removeChild("NumGPOs", ns);
        if (element.getChildren().size() > 0) {
            String message = "GPIOCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setNumGPIs(UnsignedShort numGPIs) {
        this.numGPIs = numGPIs;
    }

    public void setNumGPOs(UnsignedShort numGPOs) {
        this.numGPOs = numGPOs;
    }

    public UnsignedShort getNumGPIs() {
        return this.numGPIs;
    }

    public UnsignedShort getNumGPOs() {
        return this.numGPOs;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "GPIOCapabilities";
    }

    public String toString() {
        String result = "GPIOCapabilities: ";
        result = result + ", numGPIs: ";
        result = result + this.numGPIs;
        result = result + ", numGPOs: ";
        result = result + this.numGPOs;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

