/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolEPCMemorySelector;
import org.llrp.ltk.generated.parameters.C1G2EPCMemorySelector;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class TagReportContentSelector
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(238);
    private static final Logger LOGGER = Logger.getLogger(TagReportContentSelector.class);
    protected Bit enableROSpecID;
    protected Bit enableSpecIndex;
    protected Bit enableInventoryParameterSpecID;
    protected Bit enableAntennaID;
    protected Bit enableChannelIndex;
    protected Bit enablePeakRSSI;
    protected Bit enableFirstSeenTimestamp;
    protected Bit enableLastSeenTimestamp;
    protected Bit enableTagSeenCount;
    protected Bit enableAccessSpecID;
    protected BitList reserved0 = new BitList(6);
    protected List<AirProtocolEPCMemorySelector> airProtocolEPCMemorySelectorList = new LinkedList<AirProtocolEPCMemorySelector>();

    public TagReportContentSelector() {
    }

    public TagReportContentSelector(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public TagReportContentSelector(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public TagReportContentSelector(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.enableROSpecID == null) {
            LOGGER.warn(" enableROSpecID not set");
            throw new MissingParameterException(" enableROSpecID not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableROSpecID.encodeBinary());
        if (this.enableSpecIndex == null) {
            LOGGER.warn(" enableSpecIndex not set");
            throw new MissingParameterException(" enableSpecIndex not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableSpecIndex.encodeBinary());
        if (this.enableInventoryParameterSpecID == null) {
            LOGGER.warn(" enableInventoryParameterSpecID not set");
            throw new MissingParameterException(" enableInventoryParameterSpecID not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableInventoryParameterSpecID.encodeBinary());
        if (this.enableAntennaID == null) {
            LOGGER.warn(" enableAntennaID not set");
            throw new MissingParameterException(" enableAntennaID not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableAntennaID.encodeBinary());
        if (this.enableChannelIndex == null) {
            LOGGER.warn(" enableChannelIndex not set");
            throw new MissingParameterException(" enableChannelIndex not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableChannelIndex.encodeBinary());
        if (this.enablePeakRSSI == null) {
            LOGGER.warn(" enablePeakRSSI not set");
            throw new MissingParameterException(" enablePeakRSSI not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enablePeakRSSI.encodeBinary());
        if (this.enableFirstSeenTimestamp == null) {
            LOGGER.warn(" enableFirstSeenTimestamp not set");
            throw new MissingParameterException(" enableFirstSeenTimestamp not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableFirstSeenTimestamp.encodeBinary());
        if (this.enableLastSeenTimestamp == null) {
            LOGGER.warn(" enableLastSeenTimestamp not set");
            throw new MissingParameterException(" enableLastSeenTimestamp not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableLastSeenTimestamp.encodeBinary());
        if (this.enableTagSeenCount == null) {
            LOGGER.warn(" enableTagSeenCount not set");
            throw new MissingParameterException(" enableTagSeenCount not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableTagSeenCount.encodeBinary());
        if (this.enableAccessSpecID == null) {
            LOGGER.warn(" enableAccessSpecID not set");
            throw new MissingParameterException(" enableAccessSpecID not set  for Parameter of Type TagReportContentSelector");
        }
        resultBits.append(this.enableAccessSpecID.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.airProtocolEPCMemorySelectorList == null) {
            LOGGER.info(" airProtocolEPCMemorySelectorList not set");
        } else {
            for (AirProtocolEPCMemorySelector field : this.airProtocolEPCMemorySelectorList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.enableROSpecID == null) {
            LOGGER.warn(" enableROSpecID not set");
            throw new MissingParameterException(" enableROSpecID not set");
        }
        element.addContent(this.enableROSpecID.encodeXML("EnableROSpecID", ns));
        if (this.enableSpecIndex == null) {
            LOGGER.warn(" enableSpecIndex not set");
            throw new MissingParameterException(" enableSpecIndex not set");
        }
        element.addContent(this.enableSpecIndex.encodeXML("EnableSpecIndex", ns));
        if (this.enableInventoryParameterSpecID == null) {
            LOGGER.warn(" enableInventoryParameterSpecID not set");
            throw new MissingParameterException(" enableInventoryParameterSpecID not set");
        }
        element.addContent(this.enableInventoryParameterSpecID.encodeXML("EnableInventoryParameterSpecID", ns));
        if (this.enableAntennaID == null) {
            LOGGER.warn(" enableAntennaID not set");
            throw new MissingParameterException(" enableAntennaID not set");
        }
        element.addContent(this.enableAntennaID.encodeXML("EnableAntennaID", ns));
        if (this.enableChannelIndex == null) {
            LOGGER.warn(" enableChannelIndex not set");
            throw new MissingParameterException(" enableChannelIndex not set");
        }
        element.addContent(this.enableChannelIndex.encodeXML("EnableChannelIndex", ns));
        if (this.enablePeakRSSI == null) {
            LOGGER.warn(" enablePeakRSSI not set");
            throw new MissingParameterException(" enablePeakRSSI not set");
        }
        element.addContent(this.enablePeakRSSI.encodeXML("EnablePeakRSSI", ns));
        if (this.enableFirstSeenTimestamp == null) {
            LOGGER.warn(" enableFirstSeenTimestamp not set");
            throw new MissingParameterException(" enableFirstSeenTimestamp not set");
        }
        element.addContent(this.enableFirstSeenTimestamp.encodeXML("EnableFirstSeenTimestamp", ns));
        if (this.enableLastSeenTimestamp == null) {
            LOGGER.warn(" enableLastSeenTimestamp not set");
            throw new MissingParameterException(" enableLastSeenTimestamp not set");
        }
        element.addContent(this.enableLastSeenTimestamp.encodeXML("EnableLastSeenTimestamp", ns));
        if (this.enableTagSeenCount == null) {
            LOGGER.warn(" enableTagSeenCount not set");
            throw new MissingParameterException(" enableTagSeenCount not set");
        }
        element.addContent(this.enableTagSeenCount.encodeXML("EnableTagSeenCount", ns));
        if (this.enableAccessSpecID == null) {
            LOGGER.warn(" enableAccessSpecID not set");
            throw new MissingParameterException(" enableAccessSpecID not set");
        }
        element.addContent(this.enableAccessSpecID.encodeXML("EnableAccessSpecID", ns));
        if (this.airProtocolEPCMemorySelectorList == null) {
            LOGGER.info("airProtocolEPCMemorySelectorList not set");
        } else {
            for (AirProtocolEPCMemorySelector field : this.airProtocolEPCMemorySelectorList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.enableROSpecID = new Bit(binary, position, Bit.length());
        this.enableSpecIndex = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableInventoryParameterSpecID = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableAntennaID = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableChannelIndex = new Bit(binary, position += Bit.length(), Bit.length());
        this.enablePeakRSSI = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableFirstSeenTimestamp = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableLastSeenTimestamp = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableTagSeenCount = new Bit(binary, position += Bit.length(), Bit.length());
        this.enableAccessSpecID = new Bit(binary, position += Bit.length(), Bit.length());
        position += Bit.length();
        position += this.reserved0.length();
        this.airProtocolEPCMemorySelectorList = new LinkedList<AirProtocolEPCMemorySelector>();
        LOGGER.trace("decoding parameter airProtocolEPCMemorySelectorList ");
        while (position < binary.length()) {
            SignedShort type;
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                short tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2EPCMemorySelector.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2EPCMemorySelector.length();
                }
                this.airProtocolEPCMemorySelectorList.add(new C1G2EPCMemorySelector(binary, position, tempLength));
                LOGGER.trace("adding C1G2EPCMemorySelector to airProtocolEPCMemorySelectorList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (foundOne) continue;
            break;
        }
        if (this.airProtocolEPCMemorySelectorList.isEmpty()) {
            LOGGER.trace("TagReportContentSelector misses optional parameter of type AirProtocolEPCMemorySelector");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EnableROSpecID", ns);
        if (temp != null) {
            this.enableROSpecID = new Bit(temp);
        }
        element.removeChild("EnableROSpecID", ns);
        temp = element.getChild("EnableSpecIndex", ns);
        if (temp != null) {
            this.enableSpecIndex = new Bit(temp);
        }
        element.removeChild("EnableSpecIndex", ns);
        temp = element.getChild("EnableInventoryParameterSpecID", ns);
        if (temp != null) {
            this.enableInventoryParameterSpecID = new Bit(temp);
        }
        element.removeChild("EnableInventoryParameterSpecID", ns);
        temp = element.getChild("EnableAntennaID", ns);
        if (temp != null) {
            this.enableAntennaID = new Bit(temp);
        }
        element.removeChild("EnableAntennaID", ns);
        temp = element.getChild("EnableChannelIndex", ns);
        if (temp != null) {
            this.enableChannelIndex = new Bit(temp);
        }
        element.removeChild("EnableChannelIndex", ns);
        temp = element.getChild("EnablePeakRSSI", ns);
        if (temp != null) {
            this.enablePeakRSSI = new Bit(temp);
        }
        element.removeChild("EnablePeakRSSI", ns);
        temp = element.getChild("EnableFirstSeenTimestamp", ns);
        if (temp != null) {
            this.enableFirstSeenTimestamp = new Bit(temp);
        }
        element.removeChild("EnableFirstSeenTimestamp", ns);
        temp = element.getChild("EnableLastSeenTimestamp", ns);
        if (temp != null) {
            this.enableLastSeenTimestamp = new Bit(temp);
        }
        element.removeChild("EnableLastSeenTimestamp", ns);
        temp = element.getChild("EnableTagSeenCount", ns);
        if (temp != null) {
            this.enableTagSeenCount = new Bit(temp);
        }
        element.removeChild("EnableTagSeenCount", ns);
        temp = element.getChild("EnableAccessSpecID", ns);
        if (temp != null) {
            this.enableAccessSpecID = new Bit(temp);
        }
        element.removeChild("EnableAccessSpecID", ns);
        this.airProtocolEPCMemorySelectorList = new LinkedList<AirProtocolEPCMemorySelector>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (!name.equals("C1G2EPCMemorySelector")) continue;
            this.airProtocolEPCMemorySelectorList.add(new C1G2EPCMemorySelector(e));
            LOGGER.trace("adding C1G2EPCMemorySelector to airProtocolEPCMemorySelectorList ");
            atLeastOnce = true;
            i.remove();
        }
        if (element.getChildren().size() > 0) {
            String message = "TagReportContentSelector has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEnableROSpecID(Bit enableROSpecID) {
        this.enableROSpecID = enableROSpecID;
    }

    public void setEnableSpecIndex(Bit enableSpecIndex) {
        this.enableSpecIndex = enableSpecIndex;
    }

    public void setEnableInventoryParameterSpecID(Bit enableInventoryParameterSpecID) {
        this.enableInventoryParameterSpecID = enableInventoryParameterSpecID;
    }

    public void setEnableAntennaID(Bit enableAntennaID) {
        this.enableAntennaID = enableAntennaID;
    }

    public void setEnableChannelIndex(Bit enableChannelIndex) {
        this.enableChannelIndex = enableChannelIndex;
    }

    public void setEnablePeakRSSI(Bit enablePeakRSSI) {
        this.enablePeakRSSI = enablePeakRSSI;
    }

    public void setEnableFirstSeenTimestamp(Bit enableFirstSeenTimestamp) {
        this.enableFirstSeenTimestamp = enableFirstSeenTimestamp;
    }

    public void setEnableLastSeenTimestamp(Bit enableLastSeenTimestamp) {
        this.enableLastSeenTimestamp = enableLastSeenTimestamp;
    }

    public void setEnableTagSeenCount(Bit enableTagSeenCount) {
        this.enableTagSeenCount = enableTagSeenCount;
    }

    public void setEnableAccessSpecID(Bit enableAccessSpecID) {
        this.enableAccessSpecID = enableAccessSpecID;
    }

    public void setAirProtocolEPCMemorySelectorList(List<AirProtocolEPCMemorySelector> airProtocolEPCMemorySelectorList) {
        this.airProtocolEPCMemorySelectorList = airProtocolEPCMemorySelectorList;
    }

    public Bit getEnableROSpecID() {
        return this.enableROSpecID;
    }

    public Bit getEnableSpecIndex() {
        return this.enableSpecIndex;
    }

    public Bit getEnableInventoryParameterSpecID() {
        return this.enableInventoryParameterSpecID;
    }

    public Bit getEnableAntennaID() {
        return this.enableAntennaID;
    }

    public Bit getEnableChannelIndex() {
        return this.enableChannelIndex;
    }

    public Bit getEnablePeakRSSI() {
        return this.enablePeakRSSI;
    }

    public Bit getEnableFirstSeenTimestamp() {
        return this.enableFirstSeenTimestamp;
    }

    public Bit getEnableLastSeenTimestamp() {
        return this.enableLastSeenTimestamp;
    }

    public Bit getEnableTagSeenCount() {
        return this.enableTagSeenCount;
    }

    public Bit getEnableAccessSpecID() {
        return this.enableAccessSpecID;
    }

    public List<AirProtocolEPCMemorySelector> getAirProtocolEPCMemorySelectorList() {
        return this.airProtocolEPCMemorySelectorList;
    }

    public void addToAirProtocolEPCMemorySelectorList(AirProtocolEPCMemorySelector airProtocolEPCMemorySelector) {
        if (this.airProtocolEPCMemorySelectorList == null) {
            this.airProtocolEPCMemorySelectorList = new LinkedList<AirProtocolEPCMemorySelector>();
        }
        this.airProtocolEPCMemorySelectorList.add(airProtocolEPCMemorySelector);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "TagReportContentSelector";
    }

    public String toString() {
        String result = "TagReportContentSelector: ";
        result = result + ", enableROSpecID: ";
        result = result + this.enableROSpecID;
        result = result + ", enableSpecIndex: ";
        result = result + this.enableSpecIndex;
        result = result + ", enableInventoryParameterSpecID: ";
        result = result + this.enableInventoryParameterSpecID;
        result = result + ", enableAntennaID: ";
        result = result + this.enableAntennaID;
        result = result + ", enableChannelIndex: ";
        result = result + this.enableChannelIndex;
        result = result + ", enablePeakRSSI: ";
        result = result + this.enablePeakRSSI;
        result = result + ", enableFirstSeenTimestamp: ";
        result = result + this.enableFirstSeenTimestamp;
        result = result + ", enableLastSeenTimestamp: ";
        result = result + this.enableLastSeenTimestamp;
        result = result + ", enableTagSeenCount: ";
        result = result + this.enableTagSeenCount;
        result = result + ", enableAccessSpecID: ";
        result = result + this.enableAccessSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

