/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedInteger96
extends LLRPNumberType {
    protected static final int LENGTH = 96;
    protected BigInteger value;

    public UnsignedInteger96(BigInteger value) {
        this.value = value;
        this.signed = true;
    }

    public UnsignedInteger96(long value) {
        this(BigInteger.valueOf(value));
    }

    public UnsignedInteger96() {
        this.signed = true;
    }

    public UnsignedInteger96(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = true;
    }

    public UnsignedInteger96(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public UnsignedInteger96(Element element) {
        this.decodeXML(element);
    }

    public UnsignedInteger96(String string) {
        this(new BigInteger(string));
        if (!this.inRange(string)) {
            throw new IllegalArgumentException("value " + string + " not in range allowed for UnsignedInteger96");
        }
    }

    @Override
    public void decodeBinary(LLRPBitList bitList) {
        String bitString = bitList.toString();
        this.value = new BigInteger(bitString, 2);
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(this.value.toString(2));
        if (result.length() < 96) {
            result.pad(96 - result.length());
        }
        return result.subList(result.length() - 96, 96);
    }

    public static int length() {
        return 96;
    }

    @Override
    public Integer toInteger() {
        return this.value.intValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    protected void setBits(Number value) {
        this.value = new BigInteger(value.toString());
    }

    @Override
    public void decodeXML(Element element) {
        this.value = new BigInteger(element.getText().trim());
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.value.toString()));
        return element;
    }

    @Override
    public String toString(int radix) {
        return this.value.toString(radix);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean inRange(long value) {
        return value >= 0L;
    }

    @Override
    public boolean inRange(String value) {
        BigInteger v = new BigInteger(value);
        boolean bigger = v.compareTo(new BigInteger("2").pow(96)) == 1;
        return !bigger && Integer.parseInt(value) >= 0;
    }
}

