/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjxArrayDirectionCapabilities;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjxArrayCapabilities
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1521);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjxArrayCapabilities.class);
    protected UnsignedInteger maxNumSectors;
    protected Bit supportsLISpecs;
    protected Bit supportsTISpecs;
    protected Bit supportsTSISpecs;
    protected Bit supportsDISpecs;
    private BitList reserved0 = new BitList(4);
    private ImpinjxArrayDirectionCapabilities impinjxArrayDirectionCapabilities;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjxArrayCapabilities() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjxArrayCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjxArrayCapabilities(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1521);
        this.decodeXML(element);
    }

    public ImpinjxArrayCapabilities(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn((Object)" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn((Object)" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.maxNumSectors == null) {
            LOGGER.warn((Object)" maxNumSectors not set");
        }
        resultBits.append(this.maxNumSectors.encodeBinary());
        if (this.supportsLISpecs == null) {
            LOGGER.warn((Object)" supportsLISpecs not set");
        }
        resultBits.append(this.supportsLISpecs.encodeBinary());
        if (this.supportsTISpecs == null) {
            LOGGER.warn((Object)" supportsTISpecs not set");
        }
        resultBits.append(this.supportsTISpecs.encodeBinary());
        if (this.supportsTSISpecs == null) {
            LOGGER.warn((Object)" supportsTSISpecs not set");
        }
        resultBits.append(this.supportsTSISpecs.encodeBinary());
        if (this.supportsDISpecs == null) {
            LOGGER.warn((Object)" supportsDISpecs not set");
        }
        resultBits.append(this.supportsDISpecs.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.impinjxArrayDirectionCapabilities != null) {
            LOGGER.info((Object)" impinjxArrayDirectionCapabilities not set");
            resultBits.append(this.impinjxArrayDirectionCapabilities.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        Element element = new Element(name, ns);
        if (this.maxNumSectors == null) {
            LOGGER.warn((Object)" maxNumSectors not set");
            throw new MissingParameterException(" maxNumSectors not set");
        }
        element.addContent(this.maxNumSectors.encodeXML("MaxNumSectors", ns));
        if (this.supportsLISpecs == null) {
            LOGGER.warn((Object)" supportsLISpecs not set");
            throw new MissingParameterException(" supportsLISpecs not set");
        }
        element.addContent(this.supportsLISpecs.encodeXML("SupportsLISpecs", ns));
        if (this.supportsTISpecs == null) {
            LOGGER.warn((Object)" supportsTISpecs not set");
            throw new MissingParameterException(" supportsTISpecs not set");
        }
        element.addContent(this.supportsTISpecs.encodeXML("SupportsTISpecs", ns));
        if (this.supportsTSISpecs == null) {
            LOGGER.warn((Object)" supportsTSISpecs not set");
            throw new MissingParameterException(" supportsTSISpecs not set");
        }
        element.addContent(this.supportsTSISpecs.encodeXML("SupportsTSISpecs", ns));
        if (this.supportsDISpecs == null) {
            LOGGER.warn((Object)" supportsDISpecs not set");
            throw new MissingParameterException(" supportsDISpecs not set");
        }
        element.addContent(this.supportsDISpecs.encodeXML("SupportsDISpecs", ns));
        if (this.impinjxArrayDirectionCapabilities == null) {
            LOGGER.info((Object)"impinjxArrayDirectionCapabilities not set");
        } else {
            element.addContent(this.impinjxArrayDirectionCapabilities.encodeXML(this.impinjxArrayDirectionCapabilities.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error((Object)("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-."));
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error((Object)("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + "."));
        }
        this.maxNumSectors = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.supportsLISpecs = new Bit(binary.subList(position += UnsignedInteger.length(), Bit.length()));
        this.supportsTISpecs = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        this.supportsTSISpecs = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        this.supportsDISpecs = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        if ((position += this.reserved0.length()) < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                UnsignedInteger subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjxArrayDirectionCapabilities.VENDOR_ID) && subType.equals(ImpinjxArrayDirectionCapabilities.PARAMETER_SUBTYPE)) {
                    this.impinjxArrayDirectionCapabilities = new ImpinjxArrayDirectionCapabilities(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("MaxNumSectors", element.getNamespace());
        if (temp != null) {
            this.maxNumSectors = new UnsignedInteger(temp);
        }
        if ((temp = element.getChild("SupportsLISpecs", element.getNamespace())) != null) {
            this.supportsLISpecs = new Bit(temp);
        }
        if ((temp = element.getChild("SupportsTISpecs", element.getNamespace())) != null) {
            this.supportsTISpecs = new Bit(temp);
        }
        if ((temp = element.getChild("SupportsTSISpecs", element.getNamespace())) != null) {
            this.supportsTSISpecs = new Bit(temp);
        }
        if ((temp = element.getChild("SupportsDISpecs", element.getNamespace())) != null) {
            this.supportsDISpecs = new Bit(temp);
        }
        if ((temp = element.getChild("ImpinjxArrayDirectionCapabilities", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjxArrayDirectionCapabilities", llrpns);
        }
        if (temp != null) {
            this.impinjxArrayDirectionCapabilities = new ImpinjxArrayDirectionCapabilities(temp);
            LOGGER.info((Object)"setting parameter impinjxArrayDirectionCapabilities for parameter ImpinjxArrayCapabilities");
        } else {
            LOGGER.info((Object)"ImpinjxArrayCapabilities misses non optional parameter of type impinjxArrayDirectionCapabilities");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug((Object)"ImpinjxArrayCapabilities misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
    }

    public void setMaxNumSectors(UnsignedInteger maxNumSectors) {
        this.maxNumSectors = maxNumSectors;
    }

    public void setSupportsLISpecs(Bit supportsLISpecs) {
        this.supportsLISpecs = supportsLISpecs;
    }

    public void setSupportsTISpecs(Bit supportsTISpecs) {
        this.supportsTISpecs = supportsTISpecs;
    }

    public void setSupportsTSISpecs(Bit supportsTSISpecs) {
        this.supportsTSISpecs = supportsTSISpecs;
    }

    public void setSupportsDISpecs(Bit supportsDISpecs) {
        this.supportsDISpecs = supportsDISpecs;
    }

    public void setImpinjxArrayDirectionCapabilities(ImpinjxArrayDirectionCapabilities impinjxArrayDirectionCapabilities) {
        this.impinjxArrayDirectionCapabilities = impinjxArrayDirectionCapabilities;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedInteger getMaxNumSectors() {
        return this.maxNumSectors;
    }

    public Bit getSupportsLISpecs() {
        return this.supportsLISpecs;
    }

    public Bit getSupportsTISpecs() {
        return this.supportsTISpecs;
    }

    public Bit getSupportsTSISpecs() {
        return this.supportsTSISpecs;
    }

    public Bit getSupportsDISpecs() {
        return this.supportsDISpecs;
    }

    public ImpinjxArrayDirectionCapabilities getImpinjxArrayDirectionCapabilities() {
        return this.impinjxArrayDirectionCapabilities;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

