/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.parameters.AISpecStopTrigger;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.InventoryParameterSpec;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray;

public class AISpec
extends TLVParameter
implements SpecParameter {
    public static final SignedShort TYPENUM = new SignedShort(183);
    private static final Logger LOGGER = Logger.getLogger(AISpec.class);
    protected UnsignedShortArray antennaIDs;
    protected AISpecStopTrigger aISpecStopTrigger;
    protected List<InventoryParameterSpec> inventoryParameterSpecList = new LinkedList<InventoryParameterSpec>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public AISpec() {
    }

    public AISpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AISpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AISpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaIDs == null) {
            LOGGER.warn((Object)" antennaIDs not set");
            throw new MissingParameterException(" antennaIDs not set  for Parameter of Type AISpec");
        }
        resultBits.append(this.antennaIDs.encodeBinary());
        if (this.aISpecStopTrigger == null) {
            LOGGER.warn((Object)" aISpecStopTrigger not set");
            throw new MissingParameterException(" aISpecStopTrigger not set");
        }
        resultBits.append(this.aISpecStopTrigger.encodeBinary());
        if (this.inventoryParameterSpecList == null) {
            LOGGER.warn((Object)" inventoryParameterSpecList not set");
            throw new MissingParameterException(" inventoryParameterSpecList not set");
        }
        for (InventoryParameterSpec inventoryParameterSpec : this.inventoryParameterSpecList) {
            resultBits.append(inventoryParameterSpec.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.antennaIDs == null) {
            LOGGER.warn((Object)" antennaIDs not set");
            throw new MissingParameterException(" antennaIDs not set");
        }
        element.addContent(this.antennaIDs.encodeXML("AntennaIDs", ns));
        if (this.aISpecStopTrigger == null) {
            LOGGER.info((Object)"aISpecStopTrigger not set");
            throw new MissingParameterException("aISpecStopTrigger not set");
        }
        element.addContent(this.aISpecStopTrigger.encodeXML(this.aISpecStopTrigger.getClass().getSimpleName(), ns));
        if (this.inventoryParameterSpecList == null) {
            LOGGER.warn((Object)" inventoryParameterSpecList not set");
            throw new MissingParameterException("  inventoryParameterSpecList not set");
        }
        for (InventoryParameterSpec inventoryParameterSpec : this.inventoryParameterSpecList) {
            element.addContent(inventoryParameterSpec.encodeXML(inventoryParameterSpec.getClass().getName().replaceAll(inventoryParameterSpec.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        boolean foundOne;
        int position = 0;
        int tempLength = 0;
        short fieldCount = new SignedShort(binary, position, UnsignedShort.length()).toShort();
        tempLength = UnsignedShortArray.length() * fieldCount + UnsignedShort.length();
        if (tempLength % 8 > 0) {
            tempLength += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for antennaIDs ");
        }
        this.antennaIDs = new UnsignedShortArray(binary, position, tempLength);
        position += tempLength;
        LOGGER.trace((Object)("decoding array of type: UnsignedShortArray with " + tempLength + " length"));
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"AISpec misses non optional parameter of type AISpecStopTrigger");
            throw new MissingParameterException("AISpec misses non optional parameter of type AISpecStopTrigger");
        }
        if (binary.get(position)) {
            AISpec aISpec = this;
            tempLength = aISpec.aISpecStopTrigger.length();
        }
        if (type != null && type.equals(AISpecStopTrigger.TYPENUM)) {
            this.aISpecStopTrigger = new AISpecStopTrigger(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn((Object)"AISpec misses non optional parameter of type AISpecStopTrigger");
            throw new MissingParameterException("AISpec misses non optional parameter of type AISpecStopTrigger");
        }
        LOGGER.trace((Object)(" aISpecStopTrigger is instantiated with AISpecStopTrigger with length" + tempLength));
        this.inventoryParameterSpecList = new LinkedList<InventoryParameterSpec>();
        LOGGER.trace((Object)"decoding parameter inventoryParameterSpecList ");
        while (position < binary.length()) {
            foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(InventoryParameterSpec.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = InventoryParameterSpec.length();
                }
                this.inventoryParameterSpecList.add(new InventoryParameterSpec(binary, position, tempLength));
                LOGGER.trace((Object)"adding InventoryParameterSpec to inventoryParameterSpecList ");
                foundOne = true;
                position += tempLength;
            }
            if (foundOne) continue;
            break;
        }
        if (this.inventoryParameterSpecList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional inventoryParameterSpecList");
            throw new MissingParameterException("AISpec misses non optional parameter of type InventoryParameterSpec");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace((Object)"AISpec misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaIDs", ns);
        if (temp != null) {
            this.antennaIDs = new UnsignedShortArray(temp);
        }
        element.removeChild("AntennaIDs", ns);
        temp = element.getChild("AISpecStopTrigger", ns);
        if (temp != null) {
            this.aISpecStopTrigger = new AISpecStopTrigger(temp);
            LOGGER.info((Object)"setting parameter aISpecStopTrigger for parameter AISpec");
        }
        if (temp == null) {
            LOGGER.warn((Object)"AISpec misses non optional parameter of type aISpecStopTrigger");
            throw new MissingParameterException("AISpec misses non optional parameter of type aISpecStopTrigger");
        }
        element.removeChild("AISpecStopTrigger", ns);
        this.inventoryParameterSpecList = new LinkedList<InventoryParameterSpec>();
        tempList = element.getChildren("InventoryParameterSpec", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"AISpec misses non optional parameter of type inventoryParameterSpecList");
            throw new MissingParameterException("AISpec misses non optional parameter of type inventoryParameterSpecList");
        }
        for (Element e : tempList) {
            this.inventoryParameterSpecList.add(new InventoryParameterSpec(e));
            LOGGER.trace((Object)"adding InventoryParameterSpec to inventoryParameterSpecList ");
        }
        element.removeChildren("InventoryParameterSpec", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace((Object)"AISpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.trace((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace((Object)"adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "AISpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaIDs(UnsignedShortArray antennaIDs) {
        this.antennaIDs = antennaIDs;
    }

    public void setAISpecStopTrigger(AISpecStopTrigger aISpecStopTrigger) {
        this.aISpecStopTrigger = aISpecStopTrigger;
    }

    public void setInventoryParameterSpecList(List<InventoryParameterSpec> inventoryParameterSpecList) {
        this.inventoryParameterSpecList = inventoryParameterSpecList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShortArray getAntennaIDs() {
        return this.antennaIDs;
    }

    public AISpecStopTrigger getAISpecStopTrigger() {
        return this.aISpecStopTrigger;
    }

    public List<InventoryParameterSpec> getInventoryParameterSpecList() {
        return this.inventoryParameterSpecList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToInventoryParameterSpecList(InventoryParameterSpec inventoryParameterSpec) {
        if (this.inventoryParameterSpecList == null) {
            this.inventoryParameterSpecList = new LinkedList<InventoryParameterSpec>();
        }
        this.inventoryParameterSpecList.add(inventoryParameterSpec);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AISpec";
    }

    public String toString() {
        String result = "AISpec: ";
        result = result + ", antennaIDs: ";
        result = result + this.antennaIDs;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

