/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2RFControl
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(335);
    private static final Logger LOGGER = Logger.getLogger(C1G2RFControl.class);
    protected UnsignedShort modeIndex;
    protected UnsignedShort tari;

    public C1G2RFControl() {
    }

    public C1G2RFControl(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2RFControl(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public C1G2RFControl(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.modeIndex == null) {
            LOGGER.warn((Object)" modeIndex not set");
            throw new MissingParameterException(" modeIndex not set  for Parameter of Type C1G2RFControl");
        }
        resultBits.append(this.modeIndex.encodeBinary());
        if (this.tari == null) {
            LOGGER.warn((Object)" tari not set");
            throw new MissingParameterException(" tari not set  for Parameter of Type C1G2RFControl");
        }
        resultBits.append(this.tari.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.modeIndex == null) {
            LOGGER.warn((Object)" modeIndex not set");
            throw new MissingParameterException(" modeIndex not set");
        }
        element.addContent(this.modeIndex.encodeXML("ModeIndex", ns));
        if (this.tari == null) {
            LOGGER.warn((Object)" tari not set");
            throw new MissingParameterException(" tari not set");
        }
        element.addContent(this.tari.encodeXML("Tari", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.modeIndex = new UnsignedShort(binary, position, UnsignedShort.length());
        this.tari = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ModeIndex", ns);
        if (temp != null) {
            this.modeIndex = new UnsignedShort(temp);
        }
        element.removeChild("ModeIndex", ns);
        temp = element.getChild("Tari", ns);
        if (temp != null) {
            this.tari = new UnsignedShort(temp);
        }
        element.removeChild("Tari", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2RFControl has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setModeIndex(UnsignedShort modeIndex) {
        this.modeIndex = modeIndex;
    }

    public void setTari(UnsignedShort tari) {
        this.tari = tari;
    }

    public UnsignedShort getModeIndex() {
        return this.modeIndex;
    }

    public UnsignedShort getTari() {
        return this.tari;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2RFControl";
    }

    public String toString() {
        String result = "C1G2RFControl: ";
        result = result + ", modeIndex: ";
        result = result + this.modeIndex;
        result = result + ", tari: ";
        result = result + this.tari;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

