/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolOpSpec;
import org.llrp.ltk.generated.parameters.C1G2BlockErase;
import org.llrp.ltk.generated.parameters.C1G2BlockWrite;
import org.llrp.ltk.generated.parameters.C1G2Kill;
import org.llrp.ltk.generated.parameters.C1G2Lock;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.C1G2Write;
import org.llrp.ltk.generated.parameters.EPCData;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ClientRequestResponse
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(211);
    private static final Logger LOGGER = Logger.getLogger(ClientRequestResponse.class);
    protected UnsignedInteger accessSpecID;
    protected EPCData ePCData;
    protected List<AirProtocolOpSpec> airProtocolOpSpecList = new LinkedList<AirProtocolOpSpec>();

    public ClientRequestResponse() {
    }

    public ClientRequestResponse(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ClientRequestResponse(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ClientRequestResponse(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.accessSpecID == null) {
            LOGGER.warn((Object)" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set  for Parameter of Type ClientRequestResponse");
        }
        resultBits.append(this.accessSpecID.encodeBinary());
        if (this.ePCData == null) {
            LOGGER.warn((Object)" ePCData not set");
            throw new MissingParameterException(" ePCData not set");
        }
        resultBits.append(this.ePCData.encodeBinary());
        if (this.airProtocolOpSpecList == null) {
            LOGGER.info((Object)" airProtocolOpSpecList not set");
        } else {
            for (AirProtocolOpSpec field : this.airProtocolOpSpecList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.accessSpecID == null) {
            LOGGER.warn((Object)" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set");
        }
        element.addContent(this.accessSpecID.encodeXML("AccessSpecID", ns));
        if (this.ePCData == null) {
            LOGGER.info((Object)"ePCData not set");
            throw new MissingParameterException("ePCData not set");
        }
        element.addContent(this.ePCData.encodeXML(this.ePCData.getClass().getSimpleName(), ns));
        if (this.airProtocolOpSpecList == null) {
            LOGGER.info((Object)"airProtocolOpSpecList not set");
        } else {
            for (AirProtocolOpSpec field : this.airProtocolOpSpecList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.accessSpecID = new UnsignedInteger(binary, position, UnsignedInteger.length());
        position += UnsignedInteger.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"ClientRequestResponse misses non optional parameter of type EPCData");
            throw new MissingParameterException("ClientRequestResponse misses non optional parameter of type EPCData");
        }
        if (binary.get(position)) {
            ClientRequestResponse clientRequestResponse = this;
            tempLength = clientRequestResponse.ePCData.length();
        }
        if (type != null && type.equals(EPCData.TYPENUM)) {
            this.ePCData = new EPCData(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn((Object)"ClientRequestResponse misses non optional parameter of type EPCData");
            throw new MissingParameterException("ClientRequestResponse misses non optional parameter of type EPCData");
        }
        LOGGER.trace((Object)(" ePCData is instantiated with EPCData with length" + tempLength));
        this.airProtocolOpSpecList = new LinkedList<AirProtocolOpSpec>();
        LOGGER.trace((Object)"decoding parameter airProtocolOpSpecList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2Read.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Read.length();
                }
                this.airProtocolOpSpecList.add(new C1G2Read(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2Read to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Write.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Write.length();
                }
                this.airProtocolOpSpecList.add(new C1G2Write(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2Write to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Kill.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Kill.length();
                }
                this.airProtocolOpSpecList.add(new C1G2Kill(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2Kill to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Lock.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Lock.length();
                }
                this.airProtocolOpSpecList.add(new C1G2Lock(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2Lock to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockErase.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockErase.length();
                }
                this.airProtocolOpSpecList.add(new C1G2BlockErase(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2BlockErase to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockWrite.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockWrite.length();
                }
                this.airProtocolOpSpecList.add(new C1G2BlockWrite(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2BlockWrite to airProtocolOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (foundOne) continue;
            break;
        }
        if (this.airProtocolOpSpecList.isEmpty()) {
            LOGGER.trace((Object)"ClientRequestResponse misses optional parameter of type AirProtocolOpSpec");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AccessSpecID", ns);
        if (temp != null) {
            this.accessSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("AccessSpecID", ns);
        temp = element.getChild("EPCData", ns);
        if (temp != null) {
            this.ePCData = new EPCData(temp);
            LOGGER.info((Object)"setting parameter ePCData for parameter ClientRequestResponse");
        }
        if (temp == null) {
            LOGGER.warn((Object)"ClientRequestResponse misses non optional parameter of type ePCData");
            throw new MissingParameterException("ClientRequestResponse misses non optional parameter of type ePCData");
        }
        element.removeChild("EPCData", ns);
        this.airProtocolOpSpecList = new LinkedList<AirProtocolOpSpec>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("C1G2Read")) {
                this.airProtocolOpSpecList.add(new C1G2Read(e));
                LOGGER.trace((Object)"adding C1G2Read to airProtocolOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Write")) {
                this.airProtocolOpSpecList.add(new C1G2Write(e));
                LOGGER.trace((Object)"adding C1G2Write to airProtocolOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Kill")) {
                this.airProtocolOpSpecList.add(new C1G2Kill(e));
                LOGGER.trace((Object)"adding C1G2Kill to airProtocolOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Lock")) {
                this.airProtocolOpSpecList.add(new C1G2Lock(e));
                LOGGER.trace((Object)"adding C1G2Lock to airProtocolOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2BlockErase")) {
                this.airProtocolOpSpecList.add(new C1G2BlockErase(e));
                LOGGER.trace((Object)"adding C1G2BlockErase to airProtocolOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (!name.equals("C1G2BlockWrite")) continue;
            this.airProtocolOpSpecList.add(new C1G2BlockWrite(e));
            LOGGER.trace((Object)"adding C1G2BlockWrite to airProtocolOpSpecList ");
            atLeastOnce = true;
            i.remove();
        }
        if (element.getChildren().size() > 0) {
            String message = "ClientRequestResponse has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAccessSpecID(UnsignedInteger accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public void setEPCData(EPCData ePCData) {
        this.ePCData = ePCData;
    }

    public void setAirProtocolOpSpecList(List<AirProtocolOpSpec> airProtocolOpSpecList) {
        this.airProtocolOpSpecList = airProtocolOpSpecList;
    }

    public UnsignedInteger getAccessSpecID() {
        return this.accessSpecID;
    }

    public EPCData getEPCData() {
        return this.ePCData;
    }

    public List<AirProtocolOpSpec> getAirProtocolOpSpecList() {
        return this.airProtocolOpSpecList;
    }

    public void addToAirProtocolOpSpecList(AirProtocolOpSpec airProtocolOpSpec) {
        if (this.airProtocolOpSpecList == null) {
            this.airProtocolOpSpecList = new LinkedList<AirProtocolOpSpec>();
        }
        this.airProtocolOpSpecList.add(airProtocolOpSpec);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ClientRequestResponse";
    }

    public String toString() {
        String result = "ClientRequestResponse: ";
        result = result + ", accessSpecID: ";
        result = result + this.accessSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

