/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.KeepaliveTriggerType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;

public class KeepaliveSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(220);
    private static final Logger LOGGER = Logger.getLogger(KeepaliveSpec.class);
    protected KeepaliveTriggerType keepaliveTriggerType;
    protected UnsignedInteger periodicTriggerValue;

    public KeepaliveSpec() {
    }

    public KeepaliveSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public KeepaliveSpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public KeepaliveSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.keepaliveTriggerType == null) {
            LOGGER.warn((Object)" keepaliveTriggerType not set");
            throw new MissingParameterException(" keepaliveTriggerType not set  for Parameter of Type KeepaliveSpec");
        }
        resultBits.append(this.keepaliveTriggerType.encodeBinary());
        if (this.periodicTriggerValue == null) {
            LOGGER.warn((Object)" periodicTriggerValue not set");
            throw new MissingParameterException(" periodicTriggerValue not set  for Parameter of Type KeepaliveSpec");
        }
        resultBits.append(this.periodicTriggerValue.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.keepaliveTriggerType == null) {
            LOGGER.warn((Object)" keepaliveTriggerType not set");
            throw new MissingParameterException(" keepaliveTriggerType not set");
        }
        element.addContent(this.keepaliveTriggerType.encodeXML("KeepaliveTriggerType", ns));
        if (this.periodicTriggerValue == null) {
            LOGGER.warn((Object)" periodicTriggerValue not set");
            throw new MissingParameterException(" periodicTriggerValue not set");
        }
        element.addContent(this.periodicTriggerValue.encodeXML("PeriodicTriggerValue", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.keepaliveTriggerType = new KeepaliveTriggerType(binary, position, KeepaliveTriggerType.length());
        this.periodicTriggerValue = new UnsignedInteger(binary, position += KeepaliveTriggerType.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("KeepaliveTriggerType", ns);
        if (temp != null) {
            this.keepaliveTriggerType = new KeepaliveTriggerType(temp);
        }
        element.removeChild("KeepaliveTriggerType", ns);
        temp = element.getChild("PeriodicTriggerValue", ns);
        if (temp != null) {
            this.periodicTriggerValue = new UnsignedInteger(temp);
        }
        element.removeChild("PeriodicTriggerValue", ns);
        if (element.getChildren().size() > 0) {
            String message = "KeepaliveSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setKeepaliveTriggerType(KeepaliveTriggerType keepaliveTriggerType) {
        this.keepaliveTriggerType = keepaliveTriggerType;
    }

    public void setPeriodicTriggerValue(UnsignedInteger periodicTriggerValue) {
        this.periodicTriggerValue = periodicTriggerValue;
    }

    public KeepaliveTriggerType getKeepaliveTriggerType() {
        return this.keepaliveTriggerType;
    }

    public UnsignedInteger getPeriodicTriggerValue() {
        return this.periodicTriggerValue;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "KeepaliveSpec";
    }

    public String toString() {
        String result = "KeepaliveSpec: ";
        result = result + ", keepaliveTriggerType: ";
        result = result + this.keepaliveTriggerType;
        result = result + ", periodicTriggerValue: ";
        result = result + this.periodicTriggerValue;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

