/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.EventNotificationState;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class ReaderEventNotificationSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(244);
    private static final Logger LOGGER = Logger.getLogger(ReaderEventNotificationSpec.class);
    protected List<EventNotificationState> eventNotificationStateList = new LinkedList<EventNotificationState>();

    public ReaderEventNotificationSpec() {
    }

    public ReaderEventNotificationSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ReaderEventNotificationSpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ReaderEventNotificationSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventNotificationStateList == null) {
            LOGGER.warn((Object)" eventNotificationStateList not set");
            throw new MissingParameterException(" eventNotificationStateList not set");
        }
        for (EventNotificationState field : this.eventNotificationStateList) {
            resultBits.append(field.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.eventNotificationStateList == null) {
            LOGGER.warn((Object)" eventNotificationStateList not set");
            throw new MissingParameterException("  eventNotificationStateList not set");
        }
        for (EventNotificationState field : this.eventNotificationStateList) {
            element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.eventNotificationStateList = new LinkedList<EventNotificationState>();
        LOGGER.trace((Object)"decoding parameter eventNotificationStateList ");
        while (position < binary.length()) {
            SignedShort type;
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                short tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(EventNotificationState.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = EventNotificationState.length();
                }
                this.eventNotificationStateList.add(new EventNotificationState(binary, position, tempLength));
                LOGGER.trace((Object)"adding EventNotificationState to eventNotificationStateList ");
                foundOne = true;
                position += tempLength;
            }
            if (foundOne) continue;
            break;
        }
        if (this.eventNotificationStateList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional eventNotificationStateList");
            throw new MissingParameterException("ReaderEventNotificationSpec misses non optional parameter of type EventNotificationState");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Object temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        this.eventNotificationStateList = new LinkedList<EventNotificationState>();
        tempList = element.getChildren("EventNotificationState", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"ReaderEventNotificationSpec misses non optional parameter of type eventNotificationStateList");
            throw new MissingParameterException("ReaderEventNotificationSpec misses non optional parameter of type eventNotificationStateList");
        }
        for (Element e : tempList) {
            this.eventNotificationStateList.add(new EventNotificationState(e));
            LOGGER.trace((Object)"adding EventNotificationState to eventNotificationStateList ");
        }
        element.removeChildren("EventNotificationState", ns);
        if (element.getChildren().size() > 0) {
            String message = "ReaderEventNotificationSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventNotificationStateList(List<EventNotificationState> eventNotificationStateList) {
        this.eventNotificationStateList = eventNotificationStateList;
    }

    public List<EventNotificationState> getEventNotificationStateList() {
        return this.eventNotificationStateList;
    }

    public void addToEventNotificationStateList(EventNotificationState eventNotificationState) {
        if (this.eventNotificationStateList == null) {
            this.eventNotificationStateList = new LinkedList<EventNotificationState>();
        }
        this.eventNotificationStateList.add(eventNotificationState);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ReaderEventNotificationSpec";
    }

    public String toString() {
        String result = "ReaderEventNotificationSpec: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

