/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.CommunicationsStandard;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.UHFBandCapabilities;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class RegulatoryCapabilities
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(143);
    private static final Logger LOGGER = Logger.getLogger(RegulatoryCapabilities.class);
    protected UnsignedShort countryCode;
    protected CommunicationsStandard communicationsStandard;
    protected UHFBandCapabilities uHFBandCapabilities;
    protected List<Custom> customList = new LinkedList<Custom>();

    public RegulatoryCapabilities() {
    }

    public RegulatoryCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RegulatoryCapabilities(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public RegulatoryCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.countryCode == null) {
            LOGGER.warn((Object)" countryCode not set");
            throw new MissingParameterException(" countryCode not set  for Parameter of Type RegulatoryCapabilities");
        }
        resultBits.append(this.countryCode.encodeBinary());
        if (this.communicationsStandard == null) {
            LOGGER.warn((Object)" communicationsStandard not set");
            throw new MissingParameterException(" communicationsStandard not set  for Parameter of Type RegulatoryCapabilities");
        }
        resultBits.append(this.communicationsStandard.encodeBinary());
        if (this.uHFBandCapabilities == null) {
            LOGGER.info((Object)" uHFBandCapabilities not set");
        } else {
            resultBits.append(this.uHFBandCapabilities.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.countryCode == null) {
            LOGGER.warn((Object)" countryCode not set");
            throw new MissingParameterException(" countryCode not set");
        }
        element.addContent(this.countryCode.encodeXML("CountryCode", ns));
        if (this.communicationsStandard == null) {
            LOGGER.warn((Object)" communicationsStandard not set");
            throw new MissingParameterException(" communicationsStandard not set");
        }
        element.addContent(this.communicationsStandard.encodeXML("CommunicationsStandard", ns));
        if (this.uHFBandCapabilities == null) {
            LOGGER.info((Object)"uHFBandCapabilities not set");
        } else {
            element.addContent(this.uHFBandCapabilities.encodeXML(this.uHFBandCapabilities.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.countryCode = new UnsignedShort(binary, position, UnsignedShort.length());
        this.communicationsStandard = new CommunicationsStandard(binary, position += UnsignedShort.length(), CommunicationsStandard.length());
        position += CommunicationsStandard.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"RegulatoryCapabilities misses optional parameter of type UHFBandCapabilities");
        }
        if (binary.get(position)) {
            RegulatoryCapabilities regulatoryCapabilities = this;
            tempLength = regulatoryCapabilities.uHFBandCapabilities.length();
        }
        if (type != null && type.equals(UHFBandCapabilities.TYPENUM)) {
            this.uHFBandCapabilities = new UHFBandCapabilities(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" uHFBandCapabilities is instantiated with UHFBandCapabilities with length" + tempLength));
        } else {
            LOGGER.trace((Object)"RegulatoryCapabilities misses optional parameter of type UHFBandCapabilities");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace((Object)"RegulatoryCapabilities misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("CountryCode", ns);
        if (temp != null) {
            this.countryCode = new UnsignedShort(temp);
        }
        element.removeChild("CountryCode", ns);
        temp = element.getChild("CommunicationsStandard", ns);
        if (temp != null) {
            this.communicationsStandard = new CommunicationsStandard(temp);
        }
        element.removeChild("CommunicationsStandard", ns);
        temp = element.getChild("UHFBandCapabilities", ns);
        if (temp != null) {
            this.uHFBandCapabilities = new UHFBandCapabilities(temp);
            LOGGER.info((Object)"setting parameter uHFBandCapabilities for parameter RegulatoryCapabilities");
        }
        if (temp == null) {
            LOGGER.trace((Object)"RegulatoryCapabilities misses optional parameter of type uHFBandCapabilities");
        }
        element.removeChild("UHFBandCapabilities", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace((Object)"RegulatoryCapabilities misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.trace((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace((Object)"adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "RegulatoryCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setCountryCode(UnsignedShort countryCode) {
        this.countryCode = countryCode;
    }

    public void setCommunicationsStandard(CommunicationsStandard communicationsStandard) {
        this.communicationsStandard = communicationsStandard;
    }

    public void setUHFBandCapabilities(UHFBandCapabilities uHFBandCapabilities) {
        this.uHFBandCapabilities = uHFBandCapabilities;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getCountryCode() {
        return this.countryCode;
    }

    public CommunicationsStandard getCommunicationsStandard() {
        return this.communicationsStandard;
    }

    public UHFBandCapabilities getUHFBandCapabilities() {
        return this.uHFBandCapabilities;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "RegulatoryCapabilities";
    }

    public String toString() {
        String result = "RegulatoryCapabilities: ";
        result = result + ", countryCode: ";
        result = result + this.countryCode;
        result = result + ", communicationsStandard: ";
        result = result + this.communicationsStandard;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

