/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class Bit
extends LLRPNumberType {
    private static final Integer LENGTH = 1;
    protected boolean value;

    public Bit(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public Bit() {
        this.value = false;
        this.signed = false;
    }

    public Bit(int x) {
        if (!this.inRange(x)) {
            throw new IllegalArgumentException("value " + x + " not in range allowed for Bit");
        }
        this.value = x != 0;
        this.signed = false;
    }

    public Bit(boolean x) {
        this.signed = x;
        this.value = x;
    }

    public Bit(Integer i) {
        this((int)i);
    }

    public Bit(String x) {
        x = x.trim();
        if (!this.inRange(x)) {
            throw new IllegalArgumentException("value " + x + " not in range");
        }
        this.value = !x.equalsIgnoreCase("0") && !x.equalsIgnoreCase("false");
        this.signed = false;
    }

    public Bit(LLRPBitList bitList) {
        this.value = bitList.get(0);
        this.signed = false;
    }

    public Bit(Boolean bool) {
        this.value = bool;
        this.signed = false;
    }

    public Bit(Element element) {
        this.decodeXML(element);
    }

    public static int length() {
        return LENGTH;
    }

    public boolean toBoolean() {
        return this.value;
    }

    public byte toByte() {
        return Integer.valueOf(this.value ? 1 : 0).byteValue();
    }

    @Override
    public Integer toInteger() {
        return this.value ? 1 : 0;
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public void decodeXML(Element element) {
        String x = element.getText().trim();
        this.value = !x.equalsIgnoreCase("0") && !x.equalsIgnoreCase("false");
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toInteger().toString()));
        return element;
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        this.value = list.get(0);
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(1);
        if (this.value) {
            result.set(0);
        } else {
            result.clear(0);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.value ? "1" : "0";
    }

    @Override
    public String toString(int radix) {
        return this.toString();
    }

    @Override
    public boolean inRange(long value) {
        return value >= 0L && value <= 1L;
    }

    @Override
    public boolean inRange(String valueString) {
        if (valueString.equals("true")) {
            return true;
        }
        if (valueString.equals("false")) {
            return true;
        }
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

