/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.util.LLRPExternalResourceResolver;
import org.xml.sax.SAXException;

public abstract class LLRPMessage {
    private static final Logger LOGGER = Logger.getLogger(LLRPMessage.class);
    public static final int RESERVEDLENGTH = 6;
    public static final int VERSIONLENGTH = 3;
    public static final int TYPENUMBERLENGTH = 10;
    public static final int MINHEADERLENGTH = 80;
    public final int messageReservedLength = 3;
    protected BitList reserved = new BitList(3);
    protected BitList version;
    protected UnsignedInteger messageID = new UnsignedInteger();
    protected UnsignedInteger messageLength = new UnsignedInteger();
    private Validator validator;
    private static Map<String, Validator> validators = new HashMap<String, Validator>();
    private static byte[] mutex = new byte[0];
    private int byteArrayLength = -1;

    public final byte[] encodeBinary() throws InvalidLLRPMessageException {
        try {
            LLRPBitList result = new LLRPBitList();
            result.append(this.reserved.encodeBinary());
            if (this.version == null) {
                throw new MissingParameterException("version not set");
            }
            result.append(this.version.encodeBinary());
            result.append(this.getTypeNum().encodeBinary().subList(6, 10));
            result.append(this.messageLength.encodeBinary());
            result.append(this.messageID.encodeBinary());
            result.append(this.encodeBinarySpecific());
            this.finalizeEncode(result);
            return result.toByteArray();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage(), e);
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage(), e);
        }
    }

    protected abstract LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException;

    public final void decodeBinary(byte[] byteArray) throws InvalidLLRPMessageException {
        this.byteArrayLength = byteArray.length;
        this.decodeBinary(new LLRPBitList(byteArray));
    }

    public final void decodeBinary(LLRPBitList bits) throws InvalidLLRPMessageException {
        try {
            if (bits.length() < 80) {
                LOGGER.error((Object)("Bit String too short, must be at least 80, is " + bits.length()));
                throw new InvalidLLRPMessageException("Invalid binary message: Bit String is too short");
            }
            Short messageType = new SignedShort(bits, 6, SignedShort.length() - 6).toShort();
            if (!messageType.equals(this.getTypeNum().toShort())) {
                LOGGER.error((Object)("incorrect type. Message of Type " + this.getTypeNum().toShort() + " expected, but message indicates " + messageType));
                throw new InvalidLLRPMessageException("incorrect type. Message of Type " + this.getTypeNum().toShort() + " expected, but message indicates " + messageType);
            }
            int position = 3;
            this.version = new BitList(3);
            for (int i = 0; i < 3; ++i) {
                if (bits.get(position + i)) {
                    this.version.set(i);
                    continue;
                }
                this.version.clear(i);
            }
            position = SignedShort.length();
            this.messageLength = new UnsignedInteger(bits, position, UnsignedInteger.length());
            this.messageID = new UnsignedInteger(bits, position += UnsignedInteger.length(), UnsignedInteger.length());
            position += UnsignedInteger.length();
            if (this.messageLength.intValue() != bits.length / 8) {
                throw new InvalidLLRPMessageException("message length not equal to length given in message ");
            }
            this.decodeBinarySpecific(bits.subList(position, bits.length() - position));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage(), e);
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage(), e);
        }
    }

    public UnsignedInteger getMessageID() {
        return this.messageID;
    }

    public UnsignedInteger getMessageLength() {
        return this.messageLength;
    }

    public abstract SignedShort getTypeNum();

    public abstract String getResponseType();

    public abstract String getName();

    public BitList getVersion() {
        return this.version;
    }

    public void setMessageID(UnsignedInteger messageID) {
        this.messageID = messageID;
    }

    public void setVersion(BitList version) {
        if (version.length() != 3) {
            throw new IllegalArgumentException("wrong length of version");
        }
        this.version = version;
    }

    protected abstract void decodeBinarySpecific(LLRPBitList var1) throws InvalidLLRPMessageException;

    private void finalizeEncode(LLRPBitList result) {
        int lengthBits = result.length();
        int lengthBytes = lengthBits / 8;
        LLRPBitList binLength = new UnsignedInteger(lengthBytes).encodeBinary();
        for (int i = 0; i < binLength.length(); ++i) {
            if (binLength.get(i)) {
                result.set(16 + i);
                continue;
            }
            result.clear(16 + i);
        }
    }

    public abstract Document encodeXML() throws InvalidLLRPMessageException;

    public abstract void decodeXML(Document var1) throws InvalidLLRPMessageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidXMLMessage(Document jdomDoc, String schemaPath) throws InvalidLLRPMessageException {
        try {
            XMLOutputter output = new XMLOutputter();
            Format f = output.getFormat();
            f.setTextMode(Format.TextMode.NORMALIZE);
            output.setFormat(f);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            output.output(jdomDoc, (OutputStream)stream);
            byte[] a = stream.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(a);
            byte[] byArray = mutex;
            synchronized (mutex) {
                this.validator = validators.get(schemaPath);
                if (this.validator == null) {
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver(new LLRPExternalResourceResolver());
                    ClassLoader cl = this.getClass().getClassLoader();
                    BufferedInputStream s = new BufferedInputStream(cl.getResourceAsStream(schemaPath));
                    Schema schema = factory.newSchema(new StreamSource(s));
                    this.validator = schema.newValidator();
                    validators.put(schemaPath, this.validator);
                }
                this.validator.validate(new StreamSource(is));
                // ** MonitorExit[var8_11] (shouldn't be in output)
            }
        }
        catch (SAXException e) {
            XMLOutputter output = new XMLOutputter();
            output.setFormat(Format.getPrettyFormat());
            LOGGER.warn((Object)("LTK XML message can not be validated against schema " + schemaPath + output.outputString(jdomDoc) + "because " + e.getMessage()));
            throw new InvalidLLRPMessageException("LTK XML message can not be validated against schema " + schemaPath + output.outputString(jdomDoc) + "because " + e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("LLRP.xsd schema cannot be found " + schemaPath));
            throw new InvalidLLRPMessageException("LLRP.xsd schema cannot be found " + schemaPath, e);
        }
        {
            return true;
        }
    }

    public String toXMLString() throws InvalidLLRPMessageException {
        Document d = this.encodeXML();
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        return outputter.outputString(d);
    }

    public String toBinaryString() throws InvalidLLRPMessageException {
        return new LLRPBitList(this.encodeBinary()).toString();
    }

    public String toHexString() throws InvalidLLRPMessageException {
        byte[] bytes = this.encodeBinary();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append((Integer.toString((b & 0xFF) + 256, 16).substring(1) + " ").toUpperCase());
        }
        return sb.toString();
    }
}

