/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.ReaderModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AntennaUtilities {
    private static final List<Integer> XARRAY_OPTIMIZED_ANTENNAS = Arrays.asList(45, 16, 35, 6, 41, 28, 47, 18, 29, 8, 43, 22, 4, 49, 20, 31, 10, 37, 24, 51, 14, 33, 12, 39, 26, 2, 13, 32, 11, 38, 25, 52, 15, 34, 5, 40, 27, 46, 1, 17, 36, 7, 42, 21, 48, 19, 30, 9, 44, 23, 50, 3);
    private static final List<Integer> XSPAN_OPTIMIZED_ANTENNAS = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
    private static final Map<ReaderModel, List<Integer>> READER_MODEL_TO_OPTIMIZED_ANTENNAS = new HashMap<ReaderModel, List<Integer>>(){
        {
            this.put(ReaderModel.XArray, XARRAY_OPTIMIZED_ANTENNAS);
            this.put(ReaderModel.XArrayEAP, XARRAY_OPTIMIZED_ANTENNAS);
            this.put(ReaderModel.XArrayWM, XARRAY_OPTIMIZED_ANTENNAS);
            this.put(ReaderModel.XSpan, XSPAN_OPTIMIZED_ANTENNAS);
        }
    };
    private static final Map<Integer, List<Integer>> XARRAY_SECTOR_TO_BEAM_MAP = new HashMap<Integer, List<Integer>>(){
        {
            this.put(1, Arrays.asList(1, 2, 3, 4));
            this.put(2, Arrays.asList(5, 13, 21, 29, 37, 45));
            this.put(3, Arrays.asList(6, 14, 22, 30, 38, 46));
            this.put(4, Arrays.asList(7, 15, 23, 31, 39, 47));
            this.put(5, Arrays.asList(8, 16, 24, 32, 40, 48));
            this.put(6, Arrays.asList(9, 17, 25, 33, 41, 49));
            this.put(7, Arrays.asList(10, 18, 26, 34, 42, 50));
            this.put(8, Arrays.asList(11, 19, 27, 35, 43, 51));
            this.put(9, Arrays.asList(12, 20, 28, 36, 44, 52));
        }
    };
    private static final Map<Integer, List<Integer>> XSPAN_SECTOR_TO_BEAM_MAP = new HashMap<Integer, List<Integer>>(){
        {
            this.put(1, Arrays.asList(1));
            this.put(2, Arrays.asList(2, 4, 6, 8, 10, 12));
            this.put(3, Arrays.asList(3, 5, 7, 9, 11, 13));
        }
    };
    private static final Map<ReaderModel, Map<Integer, List<Integer>>> READER_MODEL_TO_SECTOR_BEAM_MAP = new HashMap<ReaderModel, Map<Integer, List<Integer>>>(){
        {
            this.put(ReaderModel.XArray, XARRAY_SECTOR_TO_BEAM_MAP);
            this.put(ReaderModel.XArrayEAP, XARRAY_SECTOR_TO_BEAM_MAP);
            this.put(ReaderModel.XArrayWM, XARRAY_SECTOR_TO_BEAM_MAP);
            this.put(ReaderModel.XSpan, XSPAN_SECTOR_TO_BEAM_MAP);
        }
    };
    private static final Map<Integer, List<Integer>> XARRAY_RING_TO_BEAM_MAP = new HashMap<Integer, List<Integer>>(){
        {
            this.put(1, Arrays.asList(1, 2, 3, 4));
            this.put(2, Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12));
            this.put(3, Arrays.asList(13, 14, 15, 16, 17, 18, 19, 20));
            this.put(4, Arrays.asList(21, 22, 23, 24, 25, 26, 27, 28));
            this.put(5, Arrays.asList(29, 30, 31, 32, 33, 34, 35, 36));
            this.put(6, Arrays.asList(37, 38, 39, 40, 41, 42, 43, 44));
            this.put(7, Arrays.asList(45, 46, 47, 48, 49, 50, 51, 52));
        }
    };

    private AntennaUtilities() {
    }

    public static List<Integer> GetOptimizedAntennaList(ReaderModel model) {
        List<Object> optimizedAntennaList = new ArrayList();
        if (READER_MODEL_TO_OPTIMIZED_ANTENNAS.containsKey((Object)model)) {
            optimizedAntennaList = READER_MODEL_TO_OPTIMIZED_ANTENNAS.get((Object)model);
        }
        return Collections.unmodifiableList(optimizedAntennaList);
    }

    public static List<Integer> GetAntennaIdsBySector(List<? extends Number> sectors, ReaderModel model) {
        ArrayList antennaList = new ArrayList();
        if (READER_MODEL_TO_SECTOR_BEAM_MAP.containsKey((Object)model)) {
            Map<Integer, List<Integer>> sectorToBeamMap = READER_MODEL_TO_SECTOR_BEAM_MAP.get((Object)model);
            for (Number number : sectors) {
                if (!sectorToBeamMap.containsKey(number.intValue())) continue;
                antennaList.addAll(sectorToBeamMap.get(number.intValue()));
            }
        }
        return Collections.unmodifiableList(antennaList);
    }

    public static List<Integer> GetAvailableSectors(ReaderModel model) {
        ArrayList<Integer> sectorList = new ArrayList<Integer>();
        if (READER_MODEL_TO_SECTOR_BEAM_MAP.containsKey((Object)model)) {
            sectorList.addAll(READER_MODEL_TO_SECTOR_BEAM_MAP.get((Object)model).keySet());
        }
        return Collections.unmodifiableList(sectorList);
    }

    public static List<Integer> GetAntennaIdsByRing(List<? extends Number> rings, ReaderModel model) {
        ArrayList antennaList = new ArrayList();
        if (model.isXArray()) {
            for (Number number : rings) {
                if (!XARRAY_RING_TO_BEAM_MAP.containsKey(number.intValue())) continue;
                antennaList.addAll(XARRAY_RING_TO_BEAM_MAP.get(number.intValue()));
            }
        }
        return Collections.unmodifiableList(antennaList);
    }
}

