/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import java.util.HashMap;
import java.util.Map;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class MarginReadMask {
    private short[] mask = new short[0];
    private int bitLength = 0;

    public short[] getMask() {
        return this.mask;
    }

    private void setMask(short[] mask) {
        this.mask = mask;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public void setBitLength(int bitLength) {
        this.bitLength = bitLength;
    }

    public void setMaskFromHexString(String str) throws OctaneSdkException {
        MarginReadMask.validateInputString(str, StringType.Hex);
        str = str.trim();
        int length = str.length();
        int totalWidth = length % 4 == 0 ? length : (length / 4 + 1) * 4;
        str = String.format("%-" + totalWidth + "s", str).replace(' ', '0');
        this.updateMaskFromHexString(str);
        this.setBitLength(length * 4);
    }

    public void setMaskFromBitString(String str) throws OctaneSdkException {
        MarginReadMask.validateInputString(str, StringType.Bit);
        str = str.trim();
        int length = str.length();
        int totalWidth = length % 16 == 0 ? length : (length / 16 + 1) * 16;
        str = String.format("%-" + totalWidth + "s", str).replace(' ', '0');
        String hexString = MarginReadMask.bitStringToHexString(str);
        this.updateMaskFromHexString(hexString);
        this.setBitLength(length);
    }

    public String toHexWordString() {
        StringBuilder result = new StringBuilder();
        for (short word : this.mask) {
            result.append(String.format("%04x ", 0xFFFF & word).toUpperCase());
        }
        return result.toString();
    }

    public String toHexString() {
        return this.toHexWordString().replaceAll("\\s+", "");
    }

    private static String bitStringToHexString(String binary) {
        StringBuilder result = new StringBuilder(binary.length() / 4 + 1);
        for (int i = 0; i < binary.length(); i += 8) {
            String eightBits = binary.substring(i, i + 8);
            int decimal = Integer.parseInt(eightBits, 2);
            result.append(Integer.toString(decimal, 16));
        }
        return result.toString();
    }

    private void updateMaskFromHexString(String str) {
        str = str.replaceAll("(.{4})(?!$)", "$1 ");
        this.setMask(new UnsignedShortArray_HEX(str).toShortArray());
    }

    private static void validateInputString(String str, StringType stringType) throws OctaneSdkException {
        if (str == null || str.length() == 0) {
            throw new OctaneSdkException("The given string is null or empty.");
        }
        if ((str = str.trim()).length() == 0) {
            throw new OctaneSdkException("The given string has no valid characters.");
        }
        String bitPattern = "[01]";
        String hexPattern = "[0-9a-fA-F]";
        if (stringType == StringType.Bit && str.replaceAll(bitPattern, "").length() > 0) {
            throw new OctaneSdkException("The given string contains non-bit characters.");
        }
        if (stringType == StringType.Hex && str.replaceAll(hexPattern, "").length() > 0) {
            throw new OctaneSdkException("The given string contains non-hex characters.");
        }
    }

    private static enum StringType {
        Bit(0),
        Hex(1);

        private static Map<Integer, StringType> map;
        private final int value;

        private StringType(int value) {
            this.value = value;
        }

        public static StringType valueOf(int stringTypeValue) {
            return map.get(stringTypeValue);
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap<Integer, StringType>();
            for (StringType stringType : StringType.values()) {
                map.put(stringType.value, stringType);
            }
        }
    }
}

