/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjAdvancedGPOMode;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjAdvancedGPOConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(64);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAdvancedGPOConfiguration.class);
    protected UnsignedShort gPOPortNum;
    protected ImpinjAdvancedGPOMode gPOMode;
    protected UnsignedInteger gPOPulseDurationMSec;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAdvancedGPOConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAdvancedGPOConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAdvancedGPOConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(64);
        this.decodeXML(element);
    }

    public ImpinjAdvancedGPOConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.gPOPortNum == null) {
            LOGGER.warn(" gPOPortNum not set");
        }
        resultBits.append(this.gPOPortNum.encodeBinary());
        if (this.gPOMode == null) {
            LOGGER.warn(" gPOMode not set");
        }
        resultBits.append(this.gPOMode.encodeBinary());
        if (this.gPOPulseDurationMSec == null) {
            LOGGER.warn(" gPOPulseDurationMSec not set");
        }
        resultBits.append(this.gPOPulseDurationMSec.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        Element element = new Element(name, ns);
        if (this.gPOPortNum == null) {
            LOGGER.warn(" gPOPortNum not set");
            throw new MissingParameterException(" gPOPortNum not set");
        }
        element.addContent(this.gPOPortNum.encodeXML("GPOPortNum", ns));
        if (this.gPOMode == null) {
            LOGGER.warn(" gPOMode not set");
            throw new MissingParameterException(" gPOMode not set");
        }
        element.addContent(this.gPOMode.encodeXML("GPOMode", ns));
        if (this.gPOPulseDurationMSec == null) {
            LOGGER.warn(" gPOPulseDurationMSec not set");
            throw new MissingParameterException(" gPOPulseDurationMSec not set");
        }
        element.addContent(this.gPOPulseDurationMSec.encodeXML("GPOPulseDurationMSec", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.gPOPortNum = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.gPOMode = new ImpinjAdvancedGPOMode(binary.subList(position += UnsignedShort.length(), ImpinjAdvancedGPOMode.length()));
        this.gPOPulseDurationMSec = new UnsignedInteger(binary.subList(position += ImpinjAdvancedGPOMode.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("GPOPortNum", element.getNamespace());
        if (temp != null) {
            this.gPOPortNum = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("GPOMode", element.getNamespace())) != null) {
            this.gPOMode = new ImpinjAdvancedGPOMode(temp);
        }
        if ((temp = element.getChild("GPOPulseDurationMSec", element.getNamespace())) != null) {
            this.gPOPulseDurationMSec = new UnsignedInteger(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAdvancedGPOConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setGPOPortNum(UnsignedShort gPOPortNum) {
        this.gPOPortNum = gPOPortNum;
    }

    public void setGPOMode(ImpinjAdvancedGPOMode gPOMode) {
        this.gPOMode = gPOMode;
    }

    public void setGPOPulseDurationMSec(UnsignedInteger gPOPulseDurationMSec) {
        this.gPOPulseDurationMSec = gPOPulseDurationMSec;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getGPOPortNum() {
        return this.gPOPortNum;
    }

    public ImpinjAdvancedGPOMode getGPOMode() {
        return this.gPOMode;
    }

    public UnsignedInteger getGPOPulseDurationMSec() {
        return this.gPOPulseDurationMSec;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

