/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.AccessSpec;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ADD_ACCESSSPEC
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(40);
    private static final Logger LOGGER = Logger.getLogger(ADD_ACCESSSPEC.class);
    public static final String RESPONSETYPE = "ADD_ACCESSSPEC_RESPONSE";
    protected AccessSpec accessSpec;

    public ADD_ACCESSSPEC() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public ADD_ACCESSSPEC(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public ADD_ACCESSSPEC(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public ADD_ACCESSSPEC(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.accessSpec == null) {
            LOGGER.warn(" accessSpec not set");
            throw new InvalidLLRPMessageException(" accessSpec not set");
        }
        resultBits.append(this.accessSpec.encodeBinary());
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("ADD_ACCESSSPEC", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.30"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.accessSpec == null) {
                LOGGER.info("accessSpec not set");
                throw new MissingParameterException("accessSpec not set");
            }
            root.addContent(this.accessSpec.encodeXML(this.accessSpec.getClass().getSimpleName(), ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("ADD_ACCESSSPEC misses non optional parameter of type AccessSpec");
            throw new InvalidLLRPMessageException("ADD_ACCESSSPEC misses non optional parameter of type AccessSpec");
        }
        if (binary.get(position)) {
            ADD_ACCESSSPEC aDD_ACCESSSPEC = this;
            tempLength = aDD_ACCESSSPEC.accessSpec.length();
        }
        if (type != null && type.equals(AccessSpec.TYPENUM)) {
            this.accessSpec = new AccessSpec(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("ADD_ACCESSSPEC misses non optional parameter of type AccessSpec");
            throw new InvalidLLRPMessageException("ADD_ACCESSSPEC misses non optional parameter of type AccessSpec");
        }
        LOGGER.trace(" accessSpec is instantiated with AccessSpec with length" + tempLength);
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("AccessSpec", ns);
            if (temp == null) {
                LOGGER.warn("ADD_ACCESSSPEC misses non optional parameter of type accessSpec");
                throw new MissingParameterException("ADD_ACCESSSPEC misses non optional parameter of type accessSpec");
            }
            this.accessSpec = new AccessSpec(temp);
            LOGGER.info("setting parameter accessSpec for parameter ADD_ACCESSSPEC");
            root.removeChild("AccessSpec", ns);
            if (root.getChildren().size() > 0) {
                String message = "ADD_ACCESSSPEC has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setAccessSpec(AccessSpec accessSpec) {
        this.accessSpec = accessSpec;
    }

    public AccessSpec getAccessSpec() {
        return this.accessSpec;
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "ADD_ACCESSSPEC";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

