/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class PerAntennaReceiveSensitivityRange
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(149);
    private static final Logger LOGGER = Logger.getLogger(PerAntennaReceiveSensitivityRange.class);
    protected UnsignedShort antennaID;
    protected UnsignedShort receiveSensitivityIndexMin;
    protected UnsignedShort receiveSensitivityIndexMax;

    public PerAntennaReceiveSensitivityRange() {
    }

    public PerAntennaReceiveSensitivityRange(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public PerAntennaReceiveSensitivityRange(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public PerAntennaReceiveSensitivityRange(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type PerAntennaReceiveSensitivityRange");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.receiveSensitivityIndexMin == null) {
            LOGGER.warn(" receiveSensitivityIndexMin not set");
            throw new MissingParameterException(" receiveSensitivityIndexMin not set  for Parameter of Type PerAntennaReceiveSensitivityRange");
        }
        resultBits.append(this.receiveSensitivityIndexMin.encodeBinary());
        if (this.receiveSensitivityIndexMax == null) {
            LOGGER.warn(" receiveSensitivityIndexMax not set");
            throw new MissingParameterException(" receiveSensitivityIndexMax not set  for Parameter of Type PerAntennaReceiveSensitivityRange");
        }
        resultBits.append(this.receiveSensitivityIndexMax.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.receiveSensitivityIndexMin == null) {
            LOGGER.warn(" receiveSensitivityIndexMin not set");
            throw new MissingParameterException(" receiveSensitivityIndexMin not set");
        }
        element.addContent(this.receiveSensitivityIndexMin.encodeXML("ReceiveSensitivityIndexMin", ns));
        if (this.receiveSensitivityIndexMax == null) {
            LOGGER.warn(" receiveSensitivityIndexMax not set");
            throw new MissingParameterException(" receiveSensitivityIndexMax not set");
        }
        element.addContent(this.receiveSensitivityIndexMax.encodeXML("ReceiveSensitivityIndexMax", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.antennaID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.receiveSensitivityIndexMin = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        this.receiveSensitivityIndexMax = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("ReceiveSensitivityIndexMin", ns);
        if (temp != null) {
            this.receiveSensitivityIndexMin = new UnsignedShort(temp);
        }
        element.removeChild("ReceiveSensitivityIndexMin", ns);
        temp = element.getChild("ReceiveSensitivityIndexMax", ns);
        if (temp != null) {
            this.receiveSensitivityIndexMax = new UnsignedShort(temp);
        }
        element.removeChild("ReceiveSensitivityIndexMax", ns);
        if (element.getChildren().size() > 0) {
            String message = "PerAntennaReceiveSensitivityRange has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setReceiveSensitivityIndexMin(UnsignedShort receiveSensitivityIndexMin) {
        this.receiveSensitivityIndexMin = receiveSensitivityIndexMin;
    }

    public void setReceiveSensitivityIndexMax(UnsignedShort receiveSensitivityIndexMax) {
        this.receiveSensitivityIndexMax = receiveSensitivityIndexMax;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public UnsignedShort getReceiveSensitivityIndexMin() {
        return this.receiveSensitivityIndexMin;
    }

    public UnsignedShort getReceiveSensitivityIndexMax() {
        return this.receiveSensitivityIndexMax;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "PerAntennaReceiveSensitivityRange";
    }

    public String toString() {
        String result = "PerAntennaReceiveSensitivityRange: ";
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result + ", receiveSensitivityIndexMin: ";
        result = result + this.receiveSensitivityIndexMin;
        result = result + ", receiveSensitivityIndexMax: ";
        result = result + this.receiveSensitivityIndexMax;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

