/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import java.lang.reflect.Method;
import java.util.LinkedList;

public class BackgroundWorker
extends Thread {
    private final LinkedList<Method> workees = new LinkedList();
    private volatile boolean stop = false;
    private int sleepTime;

    public BackgroundWorker(int sleepTimeInMilliseconds) {
        this.setName("BackgroundWorker");
        this.setDaemon(true);
        this.sleepTime = sleepTimeInMilliseconds;
    }

    @Override
    public void run() {
        try {
            LinkedList<Method> localWorkees = this.workees;
            while (!this.stop) {
                Thread.sleep(this.sleepTime);
                for (Method workee : localWorkees) {
                    try {
                        workee.invoke((Object)this, new Object[]{null});
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (InterruptedException exception) {
            System.out.println(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void workOn(Method method) {
        LinkedList<Method> localWorkees;
        LinkedList<Method> linkedList = localWorkees = this.workees;
        synchronized (linkedList) {
            localWorkees.add(method);
            localWorkees.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        LinkedList<Method> workees;
        LinkedList<Method> linkedList = workees = this.workees;
        synchronized (linkedList) {
            return workees.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToStop() {
        this.stop = true;
        LinkedList<Method> linkedList = this.workees;
        synchronized (linkedList) {
            this.workees.clear();
            this.workees.notifyAll();
        }
        this.interrupt();
    }

    public boolean isTryingToStop() {
        return this.stop;
    }
}

