/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import java.util.HashMap;
import java.util.Map;

public enum ReaderModel {
    Unknown(0),
    SpeedwayR220(2001001),
    SpeedwayR420(2001002),
    XPortal(2001003),
    XArrayWM(2001004),
    XArrayEAP(2001006),
    XArray(2001007),
    XSpan(2001008),
    SpeedwayR120(2001009);

    private static Map<Integer, ReaderModel> map;
    private final int value;

    private ReaderModel(int value) {
        this.value = value;
    }

    public static ReaderModel valueOf(int modelNumber) {
        ReaderModel model = map.get(modelNumber);
        return model == null ? Unknown : model;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSpatialReader() {
        return this == XArrayWM || this == XArrayEAP || this == XArray || this == XSpan;
    }

    public boolean isXArray() {
        return this == XArrayWM || this == XArrayEAP || this == XArray;
    }

    static {
        map = new HashMap<Integer, ReaderModel>();
        for (ReaderModel readerModel : ReaderModel.values()) {
            map.put(readerModel.value, readerModel);
        }
    }
}

