/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.RShellSocket;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;

public class TelnetRShellSocket
implements RShellSocket {
    private static final int TELNET_PORT_NUMBER = 23;
    private Socket _socket;
    private String _username;
    private String _password;
    private int _receiveTimeout;

    public TelnetRShellSocket(String address, String username, String password, int timeoutMs) throws OctaneSdkException {
        try {
            this._socket = new Socket(address, 23);
        }
        catch (IOException e) {
            throw new OctaneSdkException("Cannot open RShell because the socket connection failed.");
        }
        this._username = username;
        this._password = password;
        this._receiveTimeout = timeoutMs;
    }

    private void throwTimeoutException(String msg) throws OctaneSdkException {
        String outMsg = "An rshell timeout occurred while: " + msg;
        throw new OctaneSdkException(outMsg);
    }

    private boolean waitForString(String s, long timeout, String failString) throws OctaneSdkException {
        String str = "";
        byte[] buffer = new byte[1024];
        if (timeout < 0L) {
            this.throwTimeoutException("waiting for string" + s);
        }
        long start = System.currentTimeMillis();
        try {
            long now;
            InputStream stream = this._socket.getInputStream();
            do {
                if (stream.available() <= 0) continue;
                int count = stream.read(buffer);
                if ((str = str + new String(Arrays.copyOf(buffer, count), Charset.forName("UTF-8"))).contains(s)) {
                    return true;
                }
                if (failString == null || failString.length() <= 0 || !str.contains(failString)) continue;
                return false;
            } while ((now = System.currentTimeMillis()) - start < timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.throwTimeoutException("waiting for command reply");
        return false;
    }

    private String waitForCmdReply(long timeout) throws OctaneSdkException {
        byte[] buffer = new byte[1024];
        String reply = "";
        InputStream stream = null;
        try {
            long now;
            stream = this._socket.getInputStream();
            if (timeout < 0L) {
                this.throwTimeoutException("waiting for command reply");
            }
            long start = System.currentTimeMillis();
            do {
                if (stream.available() <= 0) continue;
                int count = stream.read(buffer);
                if (!(reply = reply + new String(Arrays.copyOf(buffer, count), Charset.forName("UTF-8"))).endsWith("\r\n > ")) continue;
                return reply;
            } while ((now = System.currentTimeMillis()) - start < timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.throwTimeoutException("Count not get socket input stream");
        return reply;
    }

    private void sendString(String s) throws OctaneSdkException {
        try {
            this._socket.getOutputStream().write(s.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new OctaneSdkException("Could not send on rshell socket");
        }
    }

    @Override
    public boolean isConnected() {
        return this._socket.isConnected();
    }

    @Override
    public void Connect() throws OctaneSdkException {
        this.LoginRShell();
    }

    private void LoginRShell() throws OctaneSdkException {
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        this.waitForString("login:", (long)this._receiveTimeout - (now - start), null);
        this.sendString(this._username + "\n");
        now = System.currentTimeMillis();
        this.waitForString("Password:", (long)this._receiveTimeout - (now - start), null);
        this.sendString(this._password + "\n");
        now = System.currentTimeMillis();
        this.waitForString(">", (long)this._receiveTimeout - (now - start), null);
    }

    @Override
    public String Send(String cmd) throws OctaneSdkException {
        this.sendString(cmd + "\n");
        String reply = this.waitForCmdReply(this._receiveTimeout);
        return reply;
    }

    @Override
    public void Close() throws OctaneSdkException {
        if (this._socket.isConnected()) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                throw new OctaneSdkException("Could not close rshell socket");
            }
        }
    }
}

