/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class SignedByte
extends LLRPNumberType {
    private static final Integer LENGTH = 8;
    protected Integer value;

    public SignedByte(byte value) {
        this.value = new Integer(value);
        this.signed = false;
    }

    public SignedByte(String stringValue) {
        this(new Byte(stringValue));
        if (!this.inRange(stringValue)) {
            throw new IllegalArgumentException("value " + stringValue + " not in range allowed for SignedByte");
        }
    }

    public SignedByte(Integer value) {
        this(value.byteValue());
    }

    public SignedByte(int value) {
        this(new Integer(value));
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("value " + value + " not in range");
        }
    }

    public SignedByte(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public SignedByte(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public SignedByte(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public SignedByte(Element element) {
        this.decodeXML(element);
        this.signed = false;
    }

    public SignedByte() {
        this.value = 0;
        this.signed = false;
    }

    public static int length() {
        return LENGTH;
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    @Override
    public Integer toInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.toInteger();
    }

    @Override
    public void decodeXML(Element element) {
        this.value = new Integer(element.getText().trim());
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.value.toString()));
        return element;
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        String bitString = list.toString();
        if (bitString.length() == LENGTH.intValue() && bitString.charAt(0) == '1') {
            this.value = 256 - Integer.parseInt(bitString, 2);
            this.value = -this.value.intValue();
        } else {
            this.value = Integer.parseInt(bitString, 2);
        }
        this.signed = true;
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public String toString(int radix) {
        return Integer.toString(this.value, radix);
    }

    @Override
    public boolean inRange(long value) {
        return value >= -128L && value <= 127L;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

