/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import java.util.ArrayList;
import java.util.List;

public class TagData {
    private List<Integer> data = new ArrayList<Integer>();

    public static TagData fromWordList(List<Integer> data) throws OctaneSdkException {
        if (null == data) {
            throw new OctaneSdkException("Conversion failed. The word list cannot be null.");
        }
        if (0 == data.size()) {
            throw new OctaneSdkException("Conversion failed. The word list cannot be empty.");
        }
        TagData td = new TagData();
        td.data = data;
        return td;
    }

    public static TagData fromByteArray(byte[] data) throws OctaneSdkException {
        if (null == data) {
            throw new OctaneSdkException("Conversion failed. The byte array cannot be null.");
        }
        return TagData.fromByteList(TagData.byteArrayToWrapperList(data));
    }

    public static TagData fromWordArray(int[] data) throws OctaneSdkException {
        if (null == data) {
            throw new OctaneSdkException("Conversion failed. The word array cannot be null.");
        }
        return TagData.fromWordList(TagData.intArrayToWrapperList(data));
    }

    public static TagData fromWord(int data) throws OctaneSdkException {
        ArrayList<Integer> wordList = new ArrayList<Integer>();
        wordList.add(data);
        return TagData.fromWordList(wordList);
    }

    public static TagData fromByteList(List<Byte> data) throws OctaneSdkException {
        if (null == data) {
            throw new OctaneSdkException("Conversion Failed. The byte list cannot be null.");
        }
        if (0 == data.size()) {
            throw new OctaneSdkException("Conversion Failed. The byte list cannot be empty.");
        }
        TagData td = new TagData();
        int word = 0;
        int ptr = 0;
        boolean ByteOffset = false;
        if (0 != data.size() % 2) {
            ByteOffset = true;
        }
        while (ptr < data.size()) {
            if (!ByteOffset) {
                word = 0;
                word = data.get(ptr).byteValue();
                ByteOffset = true;
            } else {
                word <<= 8;
                td.data.add(word |= data.get(ptr).byteValue());
                ByteOffset = false;
            }
            ++ptr;
        }
        return td;
    }

    public static TagData fromHexString(String hex) throws OctaneSdkException {
        if (null == hex) {
            throw new OctaneSdkException("Conversion failed. The hex string cannot be null.");
        }
        String pattern = "[-\\s]";
        if ((hex = hex.replaceAll(pattern, "")).length() > 0) {
            pattern = "[0-9a-fA-F -]";
            if (0 != hex.replaceAll(pattern, "").length()) {
                throw new OctaneSdkException("Conversion failed. Hex string contains invalid characters. (" + hex + ")");
            }
            while (hex.length() % 4 != 0) {
                hex = hex + "0";
            }
            TagData td = new TagData();
            for (int ptr = 0; ptr < hex.length(); ptr += 4) {
                String word = hex.substring(ptr, ptr + 4);
                int parsedWord = Integer.parseInt(word, 16);
                td.data.add(parsedWord);
            }
            return td;
        }
        return new TagData();
    }

    public static TagData fromDoubleWord(long data) throws OctaneSdkException {
        ArrayList<Byte> b = new ArrayList<Byte>();
        for (int i = 0; i < 4; ++i) {
            b.add(0, (byte)(data & 0xFFL));
            data >>= 8;
        }
        return TagData.fromByteList(b);
    }

    private static List<Byte> byteArrayToWrapperList(byte[] byteArray) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte b : byteArray) {
            list.add(new Byte(b));
        }
        return list;
    }

    private static List<Integer> intArrayToWrapperList(int[] intArray) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int s : intArray) {
            list.add(new Integer(s));
        }
        return list;
    }

    public int getCountBytes() {
        return this.data.size() * 2;
    }

    public List<Integer> toWordList() {
        return this.data;
    }

    public String toHexWordString() {
        String result = "";
        for (Integer word : this.data) {
            String hexString = String.format("%04X", (int)word);
            if (hexString.length() > 4) {
                hexString = hexString.substring(hexString.length() - 4);
            }
            result = result + hexString + " ";
        }
        result = result.trim();
        return result;
    }

    public String toHexString() {
        return this.toHexWordString().replace(" ", "");
    }

    public String toString() {
        return this.toHexWordString();
    }

    public long toDoubleWord() throws OctaneSdkException {
        long result = 0L;
        if (this.data.size() == 0) {
            result = 0L;
        } else if (this.data.size() == 1) {
            result = this.data.get(0).intValue();
        } else if (this.data.size() == 2) {
            result = this.data.get(0).intValue();
            result <<= 16;
            result |= (long)this.data.get(1).intValue();
        } else {
            throw new OctaneSdkException("Conversion failed. Data array should only contain up to 32-bits of data.");
        }
        return result;
    }
}

