/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.GpiConfig;
import com.impinj.octane.OctaneSdkException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GpiConfigGroup
implements Iterable<GpiConfig> {
    static final int GPI_PORT_START_INDEX = 1;
    private List<GpiConfig> gpiConfigs = new ArrayList<GpiConfig>();
    private boolean gpiCollectionCreatedBySerializer = false;

    GpiConfigGroup() {
        this.gpiCollectionCreatedBySerializer = true;
    }

    GpiConfigGroup(int numGpis) {
        this.gpiCollectionCreatedBySerializer = false;
        for (int i = 0; i < numGpis; ++i) {
            this.gpiConfigs.add(new GpiConfig());
        }
    }

    public GpiConfig get(int i) {
        return this.gpiConfigs.get(i);
    }

    public void set(int i, GpiConfig newValue) {
        this.gpiConfigs.set(i, newValue);
    }

    public void add(Object config) throws OctaneSdkException {
        if (!this.gpiCollectionCreatedBySerializer) {
            throw new OctaneSdkException("Illegal operation - cannot Add to GPIConfigGroup object!");
        }
        this.gpiConfigs.add((GpiConfig)config);
    }

    public void enableAll() {
        for (int i = 0; i < this.gpiConfigs.size(); ++i) {
            this.gpiConfigs.get(i).setIsEnabled(true);
        }
    }

    public void disableAll() {
        for (int i = 0; i < this.gpiConfigs.size(); ++i) {
            this.gpiConfigs.get(i).setIsEnabled(false);
        }
    }

    protected GpiConfig getGpi(short portNumber) throws OctaneSdkException {
        for (GpiConfig gpi : this.gpiConfigs) {
            if (gpi.getPortNumber() != portNumber) continue;
            return gpi;
        }
        throw new OctaneSdkException("Invalid GPI port number specified.");
    }

    @Override
    public Iterator<GpiConfig> iterator() {
        return this.gpiConfigs.iterator();
    }
}

