/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.RShellConnectionType;
import com.impinj.octane.RShellSocket;
import com.impinj.octane.SshRShellSocket;
import com.impinj.octane.TelnetRShellSocket;

public class RshellEngine {
    private RShellSocket socket;

    public String send(String cmd) throws OctaneSdkException {
        return this.socket.Send(cmd);
    }

    public void open(String address, String username, String password, int timeoutMs, RShellConnectionType connectionType) throws OctaneSdkException {
        if (connectionType == RShellConnectionType.Telnet) {
            this.socket = new TelnetRShellSocket(address, username, password, timeoutMs);
        } else if (connectionType == RShellConnectionType.Ssh) {
            this.socket = new SshRShellSocket(address, username, password, timeoutMs);
        }
        this.socket.Connect();
    }

    @Deprecated
    public void open(String address, String username, String password, int timeoutMs) throws OctaneSdkException {
        this.open(address, username, password, timeoutMs, RShellConnectionType.Telnet);
    }

    public void openSecureSession(String address, String username, String password, int timeoutMs) throws OctaneSdkException {
        this.open(address, username, password, timeoutMs, RShellConnectionType.Ssh);
    }

    public void close() throws OctaneSdkException {
        this.socket.Close();
    }
}

