/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class ImpinjMarginRead
extends Custom
implements AccessCommandOpSpec {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1578);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjMarginRead.class);
    protected UnsignedShort opSpecID;
    protected UnsignedInteger accessPassword;
    protected TwoBitField mB;
    private BitList reserved0 = new BitList(6);
    protected UnsignedShort bitPointer;
    protected UnsignedByte bitLength;
    protected UnsignedShortArray_HEX mask;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjMarginRead() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjMarginRead(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjMarginRead(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1578);
        this.decodeXML(element);
    }

    public ImpinjMarginRead(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
        }
        resultBits.append(this.accessPassword.encodeBinary());
        if (this.mB == null) {
            LOGGER.warn(" mB not set");
        }
        resultBits.append(this.mB.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.bitPointer == null) {
            LOGGER.warn(" bitPointer not set");
        }
        resultBits.append(this.bitPointer.encodeBinary());
        if (this.bitLength == null) {
            LOGGER.warn(" bitLength not set");
        }
        resultBits.append(this.bitLength.encodeBinary());
        if (this.mask == null) {
            LOGGER.warn(" mask not set");
        }
        resultBits.append(this.mask.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.38");
        Element element = new Element(name, ns);
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set");
        }
        element.addContent(this.accessPassword.encodeXML("AccessPassword", ns));
        if (this.mB == null) {
            LOGGER.warn(" mB not set");
            throw new MissingParameterException(" mB not set");
        }
        element.addContent(this.mB.encodeXML("MB", ns));
        if (this.bitPointer == null) {
            LOGGER.warn(" bitPointer not set");
            throw new MissingParameterException(" bitPointer not set");
        }
        element.addContent(this.bitPointer.encodeXML("BitPointer", ns));
        if (this.bitLength == null) {
            LOGGER.warn(" bitLength not set");
            throw new MissingParameterException(" bitLength not set");
        }
        element.addContent(this.bitLength.encodeXML("BitLength", ns));
        if (this.mask == null) {
            LOGGER.warn(" mask not set");
            throw new MissingParameterException(" mask not set");
        }
        element.addContent(this.mask.encodeXML("Mask", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.opSpecID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.accessPassword = new UnsignedInteger(binary.subList(position += UnsignedShort.length(), UnsignedInteger.length()));
        this.mB = new TwoBitField(binary.subList(position += UnsignedInteger.length(), TwoBitField.length()));
        position += TwoBitField.length();
        this.bitPointer = new UnsignedShort(binary.subList(position += this.reserved0.length(), UnsignedShort.length()));
        this.bitLength = new UnsignedByte(binary.subList(position += UnsignedShort.length(), UnsignedByte.length()));
        short fieldCount = binary.subList(position += UnsignedByte.length(), UnsignedShort.length()).toShort();
        tempLength = UnsignedShortArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.mask = new UnsignedShortArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("OpSpecID", element.getNamespace());
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("AccessPassword", element.getNamespace())) != null) {
            this.accessPassword = new UnsignedInteger(temp);
        }
        if ((temp = element.getChild("MB", element.getNamespace())) != null) {
            this.mB = new TwoBitField(temp);
        }
        if ((temp = element.getChild("BitPointer", element.getNamespace())) != null) {
            this.bitPointer = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("BitLength", element.getNamespace())) != null) {
            this.bitLength = new UnsignedByte(temp);
        }
        if ((temp = element.getChild("Mask", element.getNamespace())) != null) {
            this.mask = new UnsignedShortArray_HEX(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjMarginRead misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setAccessPassword(UnsignedInteger accessPassword) {
        this.accessPassword = accessPassword;
    }

    public void setMB(TwoBitField mB) {
        this.mB = mB;
    }

    public void setBitPointer(UnsignedShort bitPointer) {
        this.bitPointer = bitPointer;
    }

    public void setBitLength(UnsignedByte bitLength) {
        this.bitLength = bitLength;
    }

    public void setMask(UnsignedShortArray_HEX mask) {
        this.mask = mask;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedInteger getAccessPassword() {
        return this.accessPassword;
    }

    public TwoBitField getMB() {
        return this.mB;
    }

    public UnsignedShort getBitPointer() {
        return this.bitPointer;
    }

    public UnsignedByte getBitLength() {
        return this.bitLength;
    }

    public UnsignedShortArray_HEX getMask() {
        return this.mask;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

