/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.llrp.ltk.generated.LLRPMessageFactory;
import org.llrp.ltk.types.LLRPMessage;

public class LLRPBinaryDecoder
extends CumulativeProtocolDecoder {
    private static final int MESSAGE_VERSION_KEY = -1;
    private static final int MESSAGE_LENGTH_KEY = -2;
    private static final Logger log = Logger.getLogger(LLRPBinaryDecoder.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();

    @Override
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        block9: {
            int length = -1;
            short version = -1;
            if (in.remaining() >= 6 && session.getAttribute(-2) == null) {
                if (isTraceEnabled) {
                    log.trace("determine length of message");
                }
                version = in.getShort();
                length = in.getInt();
                session.setAttribute(-2, length);
                session.setAttribute(-1, version);
                return in.remaining() >= length - 6;
            }
            if (session.getAttribute(-2) != null) {
                if (isTraceEnabled) {
                    log.trace("length already determined, see if enough bytes are available");
                }
                length = (Integer)session.getAttribute(-2);
                version = (Short)session.getAttribute(-1);
                if (in.remaining() >= length - 6) {
                    ByteBuffer bb = ByteBuffer.allocate(length);
                    bb.putShort(version);
                    bb.putInt(length);
                    in.get(bb.array(), 6, length - 6);
                    LLRPMessage message = LLRPMessageFactory.createLLRPMessage(bb.array());
                    if (isTraceEnabled) {
                        log.trace("message decoded: ");
                        log.trace(message.getClass());
                    }
                    out.write(message);
                    session.removeAttribute(-2);
                    session.removeAttribute(-1);
                    try {
                        if (in.remaining() >= 6) {
                            version = in.getShort();
                            length = in.getInt();
                            session.setAttribute(-2, length);
                            session.setAttribute(-1, version);
                            return in.remaining() - in.markValue() >= length - 6;
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        log.trace("not enough bytes to determine message length");
                        return false;
                    }
                }
                log.trace("not enough bytes to determine message length");
                return false;
            }
            log.trace("not enough bytes to determine length");
            return false;
        }
        return false;
    }
}

