/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.parameters.ImpinjAccessSpecOrdering;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockWriteWordCount;
import org.llrp.ltk.generated.custom.parameters.ImpinjOpSpecRetryCount;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjAccessSpecConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(40);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAccessSpecConfiguration.class);
    private ImpinjBlockWriteWordCount impinjBlockWriteWordCount;
    private ImpinjOpSpecRetryCount impinjOpSpecRetryCount;
    private ImpinjAccessSpecOrdering impinjAccessSpecOrdering;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAccessSpecConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAccessSpecConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAccessSpecConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(40);
        this.decodeXML(element);
    }

    public ImpinjAccessSpecConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjBlockWriteWordCount != null) {
            LOGGER.info(" impinjBlockWriteWordCount not set");
            resultBits.append(this.impinjBlockWriteWordCount.encodeBinary());
        }
        if (this.impinjOpSpecRetryCount != null) {
            LOGGER.info(" impinjOpSpecRetryCount not set");
            resultBits.append(this.impinjOpSpecRetryCount.encodeBinary());
        }
        if (this.impinjAccessSpecOrdering != null) {
            LOGGER.info(" impinjAccessSpecOrdering not set");
            resultBits.append(this.impinjAccessSpecOrdering.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.38");
        Element element = new Element(name, ns);
        if (this.impinjBlockWriteWordCount == null) {
            LOGGER.info("impinjBlockWriteWordCount not set");
        } else {
            element.addContent(this.impinjBlockWriteWordCount.encodeXML(this.impinjBlockWriteWordCount.getClass().getSimpleName(), ns));
        }
        if (this.impinjOpSpecRetryCount == null) {
            LOGGER.info("impinjOpSpecRetryCount not set");
        } else {
            element.addContent(this.impinjOpSpecRetryCount.encodeXML(this.impinjOpSpecRetryCount.getClass().getSimpleName(), ns));
        }
        if (this.impinjAccessSpecOrdering == null) {
            LOGGER.info("impinjAccessSpecOrdering not set");
        } else {
            element.addContent(this.impinjAccessSpecOrdering.encodeXML(this.impinjAccessSpecOrdering.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjBlockWriteWordCount.VENDOR_ID) && subType.equals(ImpinjBlockWriteWordCount.PARAMETER_SUBTYPE)) {
                    this.impinjBlockWriteWordCount = new ImpinjBlockWriteWordCount(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjOpSpecRetryCount.VENDOR_ID) && subType.equals(ImpinjOpSpecRetryCount.PARAMETER_SUBTYPE)) {
                    this.impinjOpSpecRetryCount = new ImpinjOpSpecRetryCount(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjAccessSpecOrdering.VENDOR_ID) && subType.equals(ImpinjAccessSpecOrdering.PARAMETER_SUBTYPE)) {
                    this.impinjAccessSpecOrdering = new ImpinjAccessSpecOrdering(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ImpinjBlockWriteWordCount", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjBlockWriteWordCount", llrpns);
        }
        if (temp != null) {
            this.impinjBlockWriteWordCount = new ImpinjBlockWriteWordCount(temp);
            LOGGER.info("setting parameter impinjBlockWriteWordCount for parameter ImpinjAccessSpecConfiguration");
        } else {
            LOGGER.info("ImpinjAccessSpecConfiguration misses non optional parameter of type impinjBlockWriteWordCount");
        }
        temp = element.getChild("ImpinjOpSpecRetryCount", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjOpSpecRetryCount", llrpns);
        }
        if (temp != null) {
            this.impinjOpSpecRetryCount = new ImpinjOpSpecRetryCount(temp);
            LOGGER.info("setting parameter impinjOpSpecRetryCount for parameter ImpinjAccessSpecConfiguration");
        } else {
            LOGGER.info("ImpinjAccessSpecConfiguration misses non optional parameter of type impinjOpSpecRetryCount");
        }
        temp = element.getChild("ImpinjAccessSpecOrdering", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjAccessSpecOrdering", llrpns);
        }
        if (temp != null) {
            this.impinjAccessSpecOrdering = new ImpinjAccessSpecOrdering(temp);
            LOGGER.info("setting parameter impinjAccessSpecOrdering for parameter ImpinjAccessSpecConfiguration");
        } else {
            LOGGER.info("ImpinjAccessSpecConfiguration misses non optional parameter of type impinjAccessSpecOrdering");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAccessSpecConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjBlockWriteWordCount(ImpinjBlockWriteWordCount impinjBlockWriteWordCount) {
        this.impinjBlockWriteWordCount = impinjBlockWriteWordCount;
    }

    public void setImpinjOpSpecRetryCount(ImpinjOpSpecRetryCount impinjOpSpecRetryCount) {
        this.impinjOpSpecRetryCount = impinjOpSpecRetryCount;
    }

    public void setImpinjAccessSpecOrdering(ImpinjAccessSpecOrdering impinjAccessSpecOrdering) {
        this.impinjAccessSpecOrdering = impinjAccessSpecOrdering;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjBlockWriteWordCount getImpinjBlockWriteWordCount() {
        return this.impinjBlockWriteWordCount;
    }

    public ImpinjOpSpecRetryCount getImpinjOpSpecRetryCount() {
        return this.impinjOpSpecRetryCount;
    }

    public ImpinjAccessSpecOrdering getImpinjAccessSpecOrdering() {
        return this.impinjAccessSpecOrdering;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

